/* sunacces.h - 9.0B - 13 Jul 2004

; Vi controls :ts=8 :ai=0
===============================================================================
| COPYRIGHT by Sunbelt Computer Systems, Inc.  See notice in 'sa_aprep.c'.    |
===============================================================================

; Revision history:

;:: 15 Oct 01 - Updated for version 8.6.				 :8.6
;:: 23 Jul 03 - Updated for version 9.0.				 :9.0
;:: 30 Jan 04 - Changed Method for SA_TxtRead, SA_TxtWrite, SA_TxtDelete,:9.0
;::		and SA_WriteEndOfFile to be 64 data types.		 :9.0
;:: 29 Mar 04 - Added sIsiInfo structure.				 :9.0
;:: 07 Jul 04 - Added SA_CopyFile.					 :9.0B
;:: 13 Jul 04 - Added new information members to sIsiInfo structure.	 :9.0B
*/

#if !defined(USE_SUNFHSYS)

#if defined(SUN_SPARC)
#include <varargs.h>
#else
#include <stdarg.h>
#endif

/* 
  Access type defs
*/
#if !defined(FAR)
#define FAR
#endif

#if defined(WIN32)
#define SA_DECL __stdcall
#define SA_EXPORT
#else	/* !WIN32 */
#if defined(DLL)
#define SA_DECL _stdcall 
#define SA_EXPORT _export
#else	/* !DLL */
#define SA_DECL
#define SA_EXPORT
#endif	/* DLL */
#endif	/* WIN32 */
/*
  Various Modes
*/
#define SA_EOR_MASK	0x0000000F /* Mask for all EOR bit definitions */
#define SA_EOR_CR	0x00000001 /* MODE input requests EOR type CR only */
#define SA_EOR_CRLF	0x00000002 /* MODE input requests EOR type CRLF */
#define SA_EOR_LF	0x00000004 /* MODE input requests EOR type LF only */
#define SA_EOR_LFCR	0x00000008 /* MODE input requests EOR type LFCR */
#define SA_OPEN_MASK	0x00000070 /* File mode mask in OPEN/PREP */
#define SA_SHARE	0x00000000 /* Share mode requested in OPEN/PREP */
#define SA_EXCLUSIVE	0x00000010 /* Exclusive mode requested in OPEN/PREP */
#define SA_SHARENF	0x00000020 /* Share NoFlush requested in OPEN/PREP */
#define SA_READ		0x00000040 /* Read mode requested in OPEN/PREP */
#define SA_PREPOVERMFD	0x00000200 /* DO NOT Prep using SUNFM */
#define SA_NOPREPTRUNC	0x00000400 /* Prep AFILE/IFILE with truncating txt file */
#define SA_FIXED	0x00001000 /* Records are Fixed Length, otherwise Variable length */
#define SA_COMPRESSED	0x00002000 /* Records are Compressed, otherwise uncompressed */
/*
  General type defs.
*/
typedef unsigned char	u8;
typedef unsigned short	u16;
typedef unsigned int	u32;
typedef		 int	s32;
#if defined(WIN32)			/* WIN32 */
#define	s64		__int64		/*90  signed 64 bit integer */
#define u64 unsigned	__int64
#else
#define s64		long long
#define	u64 unsigned	long long
#endif

/*
  Definitions for Flag1 in sIsiInfo structure.
*/

#define SA_Flag1_UPR		0x01	/* Force upper case */
#define SA_Flag1_VAR		0x02	/* pFCB:Variable length records */
#define SA_Flag1_NDUP		0x04	/* Duplicate keys NOT allowed */
#define SA_Flag1_SPC		0x08	/* pFCB:Compressed text */
#define SA_Flag1_NOEOR		0x10	/* pFCB:NO EOR is used for ISI */
#define SA_Flag1_WEOF		0x20	/* Write text @ EOF */
#define SA_Flag1_SEOR		0x40	/* Size of End of Record 00=1, 40=2 */
#define	SA_Flag1_TEOR		0xC0	/* EOR TYPE mask defined as follows */
#define	SA_Flag1_EOR_CR		0x00	/* EOR is 1 byte consisting of CR */
#define	SA_Flag1_EOR_LF		0x80	/* EOR is 1 byte consisting of LF */
#define	SA_Flag1_EOR_CRLF	0x40	/* EOR is 2 bytes consisting of CRLF */
#define	SA_Flag1_EOR_LFCR	0xC0	/* EOR is 2 bytes consisting of LFCR */

/*
  Definitions for Flag2 in sIsiInfo structure.
*/

#define SA_Flag2_LFS		0x01	/*90B Large File Support */
#define SA_Flag2_RESERVED1	0x02	/*90B*/
#define SA_Flag2_RESERVED2	0x04	/*90B*/
#define	SA_Flag2_OS_MASK	0x18	/*90B OS Platform bits*/
#define	SA_Flag2_OS_WIN		0x08	/*90B Only WINDOWS PLBWIN runtime allowed to open ISI */
#define	SA_Flag2_OS_UNIX	0x10	/*90B Only UNIX PLB runtime allowed to open ISI */

#define	MAX_NAME_LGT		255	/*90B*/
#define	INDEX_CMD_LINE_LENGTH	527	/*90B*/

#endif /* !USE_SUNFHSYS */

typedef struct {
		u32	RecordCount;
		u32	DeleteCount;
/*90B*/		u16	I_Version;	/* File version number */
/*90B*/		u16	TxtRecLen;	/* Max record length */
/*90B*/		u16	KeyLength;	/* Max key length */
/*90B*/		u8	Flag1;		/* Misc file type flags */
/*90B*/		u8	Flag2;		/* Misc file type flags */
/*90B*/		u8	I_ID[4];	/* ISI ID "SISI" */
/*90B*/		u8	DataName[MAX_NAME_LGT+1];/* Text File Name */
/*90B*/		u8	IndexInfo[INDEX_CMD_LINE_LENGTH+1];/* Index Command Line */
		} sIsiInfo;

#if !defined(USE_SUNFHSYS)

/*
  Function Prototypes
*/
#if defined(SUN_SPARC)
extern	int	SA_DECL SA_EXPORT SA_AamClose();
extern	int	SA_DECL SA_EXPORT SA_AamDelete();
extern	int	SA_DECL SA_EXPORT SA_AamDeleteKey();
extern	int	SA_DECL SA_EXPORT SA_AamInsert();
extern	long	SA_DECL SA_EXPORT SA_AamOpen();
extern	long	SA_DECL SA_EXPORT SA_AamPrep();
extern	int	SA_DECL SA_EXPORT SA_AamRead();
extern	int	SA_DECL SA_EXPORT SA_AamReadLast();
extern	int	SA_DECL SA_EXPORT SA_AamReadKG();
extern	int	SA_DECL SA_EXPORT SA_AamReadKGP();
extern	int	SA_DECL SA_EXPORT SA_AamUpdate();
extern	int	SA_DECL SA_EXPORT SA_AamWrite();

extern	int	SA_DECL SA_EXPORT SA_IsiClose();
extern	int	SA_DECL SA_EXPORT SA_IsiDelete();
extern	int	SA_DECL SA_EXPORT SA_IsiDeleteD();
extern	int	SA_DECL SA_EXPORT SA_IsiDeleteDK();
extern	int	SA_DECL SA_EXPORT SA_IsiDeleteK();
extern	int	SA_DECL SA_EXPORT SA_IsiInsert();
extern	long	SA_DECL SA_EXPORT SA_IsiOpen();
extern	long	SA_DECL SA_EXPORT SA_IsiPrep();
extern	int	SA_DECL SA_EXPORT SA_IsiRead();
extern	int	SA_DECL SA_EXPORT SA_IsiReadKey();
extern	int	SA_DECL SA_EXPORT SA_IsiReadKS();
extern	int	SA_DECL SA_EXPORT SA_IsiReadKP();
extern	int	SA_DECL SA_EXPORT SA_IsiUpdate();
extern	int	SA_DECL SA_EXPORT SA_IsiWrite();

extern	int	SA_DECL SA_EXPORT SA_TxtClose();
extern	int	SA_DECL SA_EXPORT SA_TxtDelete();
extern	int	SA_DECL SA_EXPORT SA_TxtDeleteLast();
extern	long	SA_DECL SA_EXPORT SA_TxtOpen();
extern	long	SA_DECL SA_EXPORT SA_TxtPrep();
extern	int	SA_DECL SA_EXPORT SA_TxtRead();
extern	int	SA_DECL SA_EXPORT SA_TxtUpdate();
extern	int	SA_DECL SA_EXPORT SA_TxtWrite();

extern	int	SA_DECL SA_EXPORT SA_Aamdex();
extern	int	SA_DECL SA_EXPORT SA_Erase();
extern	int	SA_DECL SA_EXPORT SA_FilePI();
extern	int	SA_DECL SA_EXPORT SA_FilePIEnd();
extern	int	SA_DECL SA_EXPORT SA_Flush();
extern	s64	SA_DECL SA_EXPORT SA_GetFilePosit();	/*90 */
extern	int	SA_DECL SA_EXPORT SA_GetErrorSubCode();
extern	int	SA_DECL SA_EXPORT SA_Index();
extern	s64	SA_DECL SA_EXPORT SA_PositEndOfFile();	/*90 */
extern	int	SA_DECL SA_EXPORT SA_Rename();
extern	int	SA_DECL SA_EXPORT SA_RepositFile();
extern	int	SA_DECL SA_EXPORT SA_Sort();
extern	int	SA_DECL SA_EXPORT SA_WriteEndOfFile();
#else
extern	int	SA_DECL SA_EXPORT SA_AamClose( long AamFh );
extern	int	SA_DECL SA_EXPORT SA_AamDelete( long AamFh );
extern	int	SA_DECL SA_EXPORT SA_AamDeleteKey( long AamFh );
extern	int	SA_DECL SA_EXPORT SA_AamInsert( long AamFh );
extern	long	SA_DECL SA_EXPORT SA_AamOpen( char *aamname, u32 aamnamelen, char dontcare, u32 mode );
extern	long	SA_DECL SA_EXPORT SA_AamPrep( char *txtname, u32 txtnamelen, char *aamname, u32 aamnamelen, u32 reclen, char *optkeylist, u32 optkeylistlen, u32 mode );
extern	int	SA_DECL SA_EXPORT SA_AamRead( long AamFh, u8 *Buffer, u32 BufferLen, u8 *KeyString, u32 KeyStringLen );
extern	int	SA_DECL SA_EXPORT SA_AamReadLast( long AamFh, u8 *Buffer, u32 BufferLen, u8 *KeyString, u32 KeyStringLen );
extern	int	SA_DECL SA_EXPORT SA_AamReadKG( long AamFh, u8 *Buffer, u32 BuffLen );
extern	int	SA_DECL SA_EXPORT SA_AamReadKGP( long AamFh, u8 *Buffer, u32 BuffLen );
extern	int	SA_DECL SA_EXPORT SA_AamUpdate( long AamFh, u8 *Buffer, u32 BuffLen );
extern	int	SA_DECL SA_EXPORT SA_AamWrite( long AamFh, u8 *Buffer, u32 BuffLen );

extern	int	SA_DECL SA_EXPORT SA_IsiClose( long IsamFh );
extern	int	SA_DECL SA_EXPORT SA_IsiDelete( long IsamFh, u8 *key, u32 keylen );
extern	int	SA_DECL SA_EXPORT SA_IsiDeleteD( long IsamFh, u8 *key, u32 keylen );
extern	int	SA_DECL SA_EXPORT SA_IsiDeleteDK( long IsamFh, u8 *key, u32 keylen );
extern	int	SA_DECL SA_EXPORT SA_IsiDeleteK( long IsamFh, u8 *key, u32 keylen );
extern	int	SA_DECL SA_EXPORT SA_IsiInsert( long IsamFh, u8 *key, u32 keylen );
extern	int	SA_DECL SA_EXPORT SA_IsiInfo( long IsamFh, sIsiInfo *IsiInfo, u32 InfoLen );
extern	long	SA_DECL SA_EXPORT SA_IsiOpen( u8 *IsiName, u32 IsiNameLen, u32 Mode);
extern	long	SA_DECL SA_EXPORT SA_IsiPrep( u8 *TxtName, u32 TxtNameLen, u8 *IsiName, u32 IsiNameLen, u32 RecLen, u8 *OptKeyList, u32 OptKeyListLen, u32 Mode );
extern	int	SA_DECL SA_EXPORT SA_IsiRead( long IsamFh, u8 *buffer, u32 len, u8 *key, u32 keylen );
extern	int	SA_DECL SA_EXPORT SA_IsiReadKey( long IsamFh, u8 *key, u32 keylen );
extern	int	SA_DECL SA_EXPORT SA_IsiReadKS( long IsamFh, u8 *buffer, u32 len );
extern	int	SA_DECL SA_EXPORT SA_IsiReadKP( long IsamFh, u8 *buffer, u32 len );
extern	int	SA_DECL SA_EXPORT SA_IsiUpdate( long IsamFh, u8 *buffer, u32 len );
extern	int	SA_DECL SA_EXPORT SA_IsiWrite( long IsamFh, u8 *buffer, u32 len, u8 *key, u32 keylen );

extern	int	SA_DECL SA_EXPORT SA_TxtClose( long TextFh );
extern	int	SA_DECL SA_EXPORT SA_TxtDelete( long TextFh, u64 Method ); /*90 */
extern	int	SA_DECL SA_EXPORT SA_TxtDeleteLast( long TextFh );
extern	long	SA_DECL SA_EXPORT SA_TxtOpen( char *TxtName, u32 TxtNameLen, u32 Mode, u16 DiskOpSize );
extern	long	SA_DECL SA_EXPORT SA_TxtPrep( char *TxtName, u32 TxtNameLen, u32 Mode, u16 DiskOpSize );
extern	int	SA_DECL SA_EXPORT SA_TxtRead( long TextFh, u8 *Buffer, u32 Len, s64 Method ); /*90 */
extern	int	SA_DECL SA_EXPORT SA_TxtUpdate( long TextFh, u8 *Buffer, u32 Len );
extern	int	SA_DECL SA_EXPORT SA_TxtWrite( long TextFh, u8 *Buffer, u32 Len, s64 Method ); /*90 */

extern	int	SA_DECL SA_EXPORT SA_CopyFile( char *SrcFileName, u32 SrcFileNameLen, char *DstFileName, u32 DstFileNameLen );
extern	int	SA_DECL SA_EXPORT SA_Aamdex( char *Command, u32 CommandLen, char *FMAddr, u32 FMAddrLen );
extern	int	SA_DECL SA_EXPORT SA_Erase( char *FileName, u32 FileNameLen );
extern	int	SA_DECL SA_EXPORT SA_FilePI( long *TextFh );
extern	int	SA_DECL SA_EXPORT SA_FilePIEnd();
extern	int	SA_DECL SA_EXPORT SA_Flush( long TextFh );
extern	s64	SA_DECL SA_EXPORT SA_GetFilePosit( long TextFh, u32 PosMode );	/*90 */
extern	int	SA_DECL SA_EXPORT SA_GetErrorSubCode();
extern	int	SA_DECL SA_EXPORT SA_Index( char *Command, u32 CommandLen, char *FMAddr, u32 FMAddrLen );
extern	s64	SA_DECL SA_EXPORT SA_PositEndOfFile( long TextFh );		/*90 */
extern	int	SA_DECL SA_EXPORT SA_Rename( char *OldFileName, u32 OldFileNameLen, char *NewFileName, u32 NewFileNameLen );
extern	int	SA_DECL SA_EXPORT SA_RepositFile( long TextFh, s64 Posit, u32 PosMode );	/*90 */
extern	int	SA_DECL SA_EXPORT SA_Sort( char *Command, u32 CommandLen, char *FMAddr, u32 FMAddrLen );
extern	int	SA_DECL SA_EXPORT SA_WriteEndOfFile( long TextFh, s64 Method ); /*90 */
#endif

#endif /* !USE_SUNFHSYS */