#include "sunacces.h"
#if defined(MSDOS)
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#else
#include <sys/types.h>
#include <sys/stat.h>
#endif
#include <fcntl.h>
#include <stdio.h>
#include <time.h>

char	IsiCtrl[ISICTRLSIZE+8];
char	AamCtrl[AAMCTRLSIZE+8];
char	buffer[10];

ErrorExit ( err )
short	err;
{
	printf ( "Error %d occured on last operation\n", err );
	exit ( 1 );
}

main ()
{
short	err;
u8	*ISI;
u8	*AAM;
int	cprog;

	ISI = IsiCtrl;
	AAM = AamCtrl;
	
	printf ( "Creating sample.txt, sample.isi & sample.aam\n" );
	if ( ( err = aamPrep ( AAM, "sample.txt", "sample.aam", 6, 8, "1,2-6", 1 ) ) < 0 ) ErrorExit ( err );
	if ( ( err = isiPrep ( ISI, "sample.txt", "sample.isi", 6, 8, "3-6", 1 ) ) < 0 ) ErrorExit ( err );
	printf ( "Writing '020003'\n" );
	if ( ( err = aamWrite ( AAM, "020003" ) ) < 0 ) ErrorExit ( err );
	if ( ( err = isiInsert ( ISI, "0003" ) ) < 0 ) ErrorExit ( err );
	printf ( "Writing '020001'\n" );
	if ( ( err = aamWrite ( AAM, "020001" ) ) < 0 ) ErrorExit ( err );
	if ( ( err = isiInsert ( ISI, "0001" ) ) < 0 ) ErrorExit ( err );
	printf ( "Writing '020002'\n" );
	if ( ( err = aamWrite ( AAM, "020002" ) ) < 0 ) ErrorExit ( err );
	if ( ( err = isiInsert ( ISI, "0002" ) ) < 0 ) ErrorExit ( err );
	printf ( "Writing '020000'\n" );
	if ( ( err = aamWrite ( AAM, "020000" ) ) < 0 ) ErrorExit ( err );
	if ( ( err = isiInsert ( ISI, "0000" ) ) < 0 ) ErrorExit ( err );
	aamClose ( AAM );
	isiClose ( ISI );
	printf ( "Opening sample.txt, sample.isi & sample.aam\n" );
	if ( ( err = aamOpen ( AAM, "sample.aam", "?", 8, 1 ) ) < 0 ) ErrorExit ( err );
	if ( ( err = isiOpen ( ISI, "sample.isi", 8, 1 ) ) < 0 ) ErrorExit ( err );
	printf ( "AAM Read '01X0'  " );
	if ( ( err = aamRead ( AAM, buffer, "01X0", 0L ) ) < 0 ) ErrorExit ( err );
	while ( err != 1 )
	{
		printf ( "Read: '%s'\n", buffer );
		printf ( "AAM ReadKG  " );
		if ( ( err = aamReadKG ( AAM, buffer ) ) < 0 ) ErrorExit ( err );
	}
	printf ( "END OF FILE\n" );
	printf ( "ISI ReadKS  " );
	if ( ( err = isiReadKS ( ISI, buffer ) ) < 0 ) ErrorExit ( err );
	while ( err != 1 )
	{
		printf ( "Read: '%s'\n", buffer );
		printf ( "ISI ReadKS  " );
		if ( ( err = isiReadKS ( ISI, buffer ) ) < 0 ) ErrorExit ( err );
	}
	printf ( "END OF FILE\n" );
	printf ( "ISI ReadKP  " );
	if ( ( err = isiReadKP ( ISI, buffer ) ) < 0 ) ErrorExit ( err );
	while ( err != 1 )
	{
		printf ( "Read: '%s'\n", buffer );
		printf ( "ISI ReadKP  " );
		if ( ( err = isiReadKP ( ISI, buffer ) ) < 0 ) ErrorExit ( err );
	}
	printf ( "BEGINNING OF FILE\n" );
	aamClose ( AAM );
	isiClose ( ISI );
}
