      ************************************************************
      * sample.cbl                                               *
      *                                                          *
      * The following code was extracted from a MicroFocus Cobol *
      * program under MS-DOS.                                    *
      *                                                          *
      * This is not intented to be a complete program, but it    *
      * is meant to show the various sunaccess proceedure calls. *
      *                                                          *
      ************************************************************
*----------------------------------------------------------------
       working-storage section.
*---- the target file names ----*
	 01 filename-length	pic 9(4) binary value 48.
	 01 text-filename	pic x(48).
	 01 aam-filename	pic x(48).
	 01 isi-filename	pic x(48).
*---- the control blocks ----*
*---- the values for the occurs clause could change. ----*
*---- check the file 'sunacces.h' for the correct values. ----*
	 01 aam-ctrl1		pic x comp-5 occurs 1892 times.
	 01 isi-ctrl1		pic x comp-5 occurs 2992 times.
*---- the read/write buffer ----*
	 01 buffer-length	pic 9(4) binary value 128.
	 01 buffer		pic x(128).
*---- error number returned by any C function call ----*
	 01 error-num		pic xx comp-5.
	 01 error-num-text	pic x(6).
	 01 error-num-temp	pic 9(5) packed-decimal.
*---- used by preps and opens ----*
	 01 record-length	pic xx comp-5.
	 01 work-length		pic xx comp-5.
	 01 access-mode		pic xx comp-5.
	 01 dcs-ptr		pointer value null.
	 01 dont-care-string	pic x(2).
	 01 opt-key-length	pic 9(4) binary value 50.
	 01 opt-key-list	pic x(50).
*---- used by read/write ----*
	 01 key-string-length	pic 9(4) binary value 50.
	 01 string1-pointer	pointer.
	 01 nullstring          pointer value null.
	 01 string1		pic x(50).
	 01 string2		pic x(50).
	 01 string3		pic x(50).

*================================================================
       procedure division.
*-----------------------------------------------------------------
       test-aamprep section.

	 call "zero-terminate" using
	    by reference	text-filename
	    by value		filename-length
	 call "zero-terminate" using
	    by reference	aam-filename
	    by value		filename-length
	 call "zero-terminate" using
	    by reference	opt-key-list
	    by value		opt-key-length

	 call "c_aamPrep" using
	   by reference	aam-ctrl1,
	   by reference	text-filename,
	   by reference	aam-filename,
	   by value	record-length,
	   by value	work-length,
	   by reference	opt-key-list,
	   by value	access-mode
	   returning error-num

	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** aamPrep Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-aamopen section.

	 call "zero-terminate" using
	    by reference	aam-filename
	    by value		filename-length
	 if dont-care-string = 0
	   then
	     set dcs-ptr to null
	   else
	     call "getadd" using
		by reference dont-care-string
		by reference dcs-ptr
	     move x"00" to dont-care-string(2:)
	   end-if

	 call "c_aamOpen" using
	   by reference	aam-ctrl1,
	   by reference	aam-filename,
	   by value	dcs-ptr,
	   by value	work-length,
	   by value	access-mode
	   returning error-num
	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** aamOpen Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-aamclose section.

	 call "c_aamClose" using
	   by value		aam-ctrl1
	   returning		error-num
	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** aamClose Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-aamwrite section.

	 call "zero-terminate" using
	    by reference	buffer
	    by value		buffer-length

	 call "c_aamWrite" using
	   by value		aam-ctrl1
	   by reference		buffer
	   returning error-num
	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** aamWrite Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-aamread section.

	 call "zero-terminate" using
	   by reference string1
	   by value key-string-length
	 call "zero-terminate" using
	   by reference string2
	   by value key-string-length
	 call "zero-terminate" using
	   by reference string3
	   by value key-string-length

	 call "c_aamRead" using
	   by reference	aam-ctrl1
	   by reference buffer
	   by reference string1
	   by reference string2
	   by reference string3
	   by value nullstring
	   returning error-num
	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** aamRead Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-aamreadkg section.

	 call "c_aamReadKG" using
	   by reference	aam-ctrl1
	   by reference	buffer
	   returning error-num
	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** aamReadKG Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-aamreadkgp section.

	 call "c_aamReadKGP" using
	   by reference	aam-ctrl1
	   by reference	buffer
	   returning error-num
	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** aamReadKGP Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-aamupdate section.

	 call "zero-terminate" using
	    by reference	buffer
	    by value		buffer-length

	 call "c_aamUpdate" using
	    by value  		aam-ctrl1
	    by reference	buffer
	    returning error-num
	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** aamUpdate Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-aamdelete section.

	 call "c_aamDelete" using
	    by value  		aam-ctrl1
 	    returning error-num
	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** aamDelete Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-aaminsert section.

	 call "c_aamInsert" using
	    by reference aam-ctrl1
	    returning error-num
	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** aamInsert Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isiprep section.

	 call "zero-terminate" using
	    by reference	text-filename
	    by value		filename-length
	 call "zero-terminate" using
	    by reference	isi-filename
	    by value		filename-length
	 call "zero-terminate" using
	    by reference	opt-key-list
	    by value		opt-key-length

	 call "c_isiPrep" using
	   by reference	isi-ctrl1,
	   by reference	text-filename,
	   by reference	isi-filename,
	   by value	record-length,
	   by value	work-length,
	   by reference	opt-key-list,
	   by value	access-mode
	   returning error-num

	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** isiPrep Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isiopen section.

	 call "zero-terminate" using
	    by reference	isi-filename
	    by value		filename-length

	 call "c_isiOpen" using
	   by reference	isi-blk1,
	   by reference	isi-filename,
	   by value	work-length,
	   by value	access-mode
	   returning error-num

	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** isiOpen Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isiclose section.

	 call "c_isiClose" using
	   by reference isi-ctrl1
	   returning error-num
	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** isiClose Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isiwrite section.

	 call "zero-terminate" using
	    by reference	buffer
	    by value		buffer-length
	 call "zero-terminate" using
	    by reference	string1
	    by value		key-string-length

	 call "c_isiWrite" using
	   by reference	isi-ctrl1
	   by reference buffer
	   by reference string1
	   returning error-num

	 if error-num not = 0
	   then
             perform convert-error
	     display "*** isiWrite Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isiread section.

	 call "zero-terminate" using
	    by reference	string1
	    by value		key-string-length

	 call "c_isiRead" using
	   by reference isi-ctrl1,
	   by reference buffer,
	   by reference string1,
	   returning error-num

	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** isiRead Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isireadks section.

	 call "c_isiReadKS" using
	   by reference isi-ctrl1
	   by reference buffer
	   returning error-num
	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** isiReadKS Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isireadkp section.

	 call "c_isiReadKP" using
	   by reference isi-ctrl1
	   by reference buffer
	   returning error-num

	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** isiReadKP Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isiinsert section.

	 call "zero-terminate" using
	    by reference	string1
	    by value		key-string-length

	 call "c_isiInsert" using
	    by reference isi-ctrl1,
	    by reference string1
	    returning error-num

	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** isiInsert Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isiupdate section.

	 call "zero-terminate" using
	    by reference	buffer
	    by value		buffer-length

	 call "c_isiUpdate" using
	    by value  		isi-ctrl1
	    by reference	buffer
	    returning error-num

	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** isiUpdate Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isidelete section.

	 call "zero-terminate" using
	   by reference	string1
	   by value	key-string-length
	 call "getadd" using
	   by reference string1, string1-pointer

	 call "c_isiDelete" using
	    by reference isi-ctrl1
	    by value string1-pointer
 	    returning error-num

	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** isiDelete Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isideleted section.

	 call "zero-terminate" using
	   by reference	string1
	   by value		key-string-length
	 call "getadd" using
	   by reference string1, string1-pointer
	 end-if

	 call "c_isiDeleteD" using
	    by reference isi-ctrl1
	    by value string1-pointer
 	    returning error-num

	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** isiDeleteD Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isideletek section.

	 call "zero-terminate" using
	   by reference	string1
	   by value		key-string-length
	 call "getadd" using
	   by reference string1, string1-pointer

	 call "c_isiDeleteK" using
	    by reference isi-ctrl1
	    by value string1-pointer
 	    returning error-num

	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** isiDeleteK Error #", error-num-text, " ***"
	 end-if.
*-----------------------------------------------------------------
       test-isideletedk section.

	 call "zero-terminate" using
	   by reference	string1
	   by value		key-string-length
	 call "getadd" using
	   by reference string1, string1-pointer

	 call "c_isiDeleteDK" using
	    by reference isi-ctrl1
	    by value string1-pointer
 	    returning error-num

	 if error-num not = 0
	   then
	     perform convert-error
	     display "*** isiDeleteDK Error #", error-num-text, " ***"
	 end-if.
*----------------------------------------------------------------
       convert-error section.
	 if error-num = 1
	   then
	     move "1" to error-num-text
	   else
	     move "-" to error-num-text
	     subtract error-num from 65536 giving error-num-temp
	     move error-num-temp to error-num-text(2:5)
	 end-if.
*-----------------------------------------------------------------
