

*********************************************************************
*                                                                   *
* Subprogram to zero terminate an arbitrary string                  *
*                                                                   *
*********************************************************************
       identification division.
	 program-id. zero-terminate.
       data division.
	 01 buff-idx		pic 9(4) binary.
	 01 end-found           pic 9(1).
       linkage section.
	 01 input-string	pic x(120).
	 01 input-length	pic 9(4) binary.

       procedure division using
		by reference input-string by value input-length.

	 add 1 to input-length giving buff-idx
	 move 0 to end-found
*---- start at the end of the string, find end of text ----*
	 perform with test after until end-found = 1
	   subtract 1 from buff-idx
	   if input-string(buff-idx:1) not = space
	     then
	       move 1 to end-found
	   end-if
	   if buff-idx = 1
	     then
	       move 1 to end-found
	   end-if
	 end-perform
	 add 1 to buff-idx

	 if buff-idx > input-length
	   then
	     display "*** Buffer Overflow, internal error ***"
	     exit program
	 end-if
*---- plug a zero at the end of the text ----*

	 move x"00" to input-string(buff-idx:1)
	 exit program.

       end program zero-terminate.

