﻿/* Date: 190103 Ver: 10.1A - Controls for visual export only */

$.widget("ui.timespinner", $.ui.spinner, {
    options: {
        step: 60 * 1000,
        page: 60 // hours
    },

    _spin: function (step, event) {

        this._super(step, event);
    },

    _parse: function (value) {
        if (typeof value === "string") {
            // already a timestamp
            if (Number(value) == value) {
                return Number(value);
            }
            return +Globalize.parseDate(value);
        }
        return value;
    },

    _format: function (value) {
        return Globalize.format(new Date(value), "t");
    }
});



/*
 * Routines to control shapes
 */

function PlbLn(si) {

}

function PlbSq(si) {

}


function PlbOv(si) {

}

function PlbRd(si) {

}

function PlbShape(rMsg) {
}

function PlbPBar(ci) {
    var progressbar = $("#" + ci.id + "D");
    var progressLabel = $("#" + ci.id  );

    progressbar[0].plbdata = new Object();
    progressbar[0].plbdata.dp = ci.dp;

    progressbar.progressbar({
      value: false,
      change: function() {
          if (progressbar[0].plbdata.dp == 1)
        {
            progressLabel.text( progressbar.progressbar( "value" ) + "%" );
        }
        else
        {
            progressLabel.text( "" );
        }
      }
       });

   progressbar.progressbar( "value", ci.cv );

}
function PlbTabC(ci) {
    var pb = $("#" + ci.id);

    pb.tabs();
}

function PlbSlide(ci) {
    var pb = $("#" + ci.id);

    if (ci.vert == 1) {
        pb.slider({
            orientation: "vertical",
            min: ci.min,
            max: ci.max,
            step: ci.step,
            value: ci.min
        });
    }
    else {
        pb.slider({
            min: ci.min,
            max: ci.max,
            value: ci.min
        });
    }

    if (ci.range != undefined) {
        if (ci.range == 1) {
            pb.slider("option", "range", "max");
        }
        else if (ci.range == 2) {
            pb.slider("option", "range", "min");
        }
        else if (ci.range == 3) {
            pb.slider("option", "range", true);
        }
    }
}

function PlbDlg(ci) {
    var pb = $("#" + ci.id);
    var el = document.getElementById(ci.id);

    el.plbdata = new Object();
    el.plbdata.canclose = false;

    if (screen.width <= 480) {
        pb.dialog({
            title: ci.tl,
            resizable: ci.res,
            autoOpen: false,
            closeOnEscape: false,
            modal: ci.mod,
            position: { my: "left top", at: "left top", of: window },
            minHeight: 20,
            minWidth: 40,
            height: ci.h,
            width: ci.w
        });
    }
    else {
        pb.dialog({
            title: ci.tl,
            resizable: ci.res,
            autoOpen: false,
            closeOnEscape: false,
            modal: ci.mod,
            minHeight: 40,
            minWidth: 40,
            height: ci.h,
            width: ci.w
        });
    }

    pb.css("background-color",ci.bgc); 

    pb.on("dialogbeforeclose", function (event, ui) { return event.target.plbdata.canclose });

}

function PlbFrm(ci) {
    var pb = $("#" + ci.id);
    var el = document.getElementById(ci.id);

    el.plbdata = new Object();
    el.plbdata.canclose = false;

    if (ci.rsz != undefined) {
        el.plbdata.resize = true;
        pb.resizable({
            autoHide: true,
            minHeight: 50, 
            minWidth: 50,
            alsoResize: "#" + ci.id + "D"
        });
        if (ci.sbr != undefined) {
            el.plbdata.scrbar = true;
            $("#" + ci.id + "D").css('overflow', 'auto');
        }
    }
}

function PlbEditFilter(event) {

    var ci = event.target.plbdata;

    if (event.charCode) {
        if (ci.et == 2) {
            if ((((event.charCode < 48) || (event.charCode > 57)) && (event.charCode >= 32))) {
                event.preventDefault();     // Prevent character input
                return;
            }
        }
        else if (ci.et == 3) {
            if ((((event.charCode < 48) || (event.charCode > 57)) && (event.charCode >= 32)
          && (event.charCode != 45) && (event.charCode != ci.ld))) {
                event.preventDefault();     // Prevent character input
                return;
            }
        }
        else if (ci.et == 6) {
            if ((((event.charCode < 48) || (event.charCode > 57)) && (event.charCode >= 32)
          && (event.charCode != 45) && (event.charCode != ci.ld) && (event.charCode != ci.lt))) {
                event.preventDefault();     // Prevent character input
                return;
            }
        }
    }

    if (ci.ot && (event.target.selectionStart == event.target.selectionEnd)) {
        event.target.selectionEnd += 1;
    }
}

function PlbEdit(ci) {
    var el = document.getElementById(ci.id);

    el.plbdata = new Object();
    el.plbdata.ld = ci.ld;
    if (ci.lt == undefined) {
    	el.plbdata.lt = 44;
    }
    else {
    	el.plbdata.lt = ci.lt;
    }
    el.plbdata.et = ci.et;
    if ((ci.ro == undefined) || (ci.ro != 1)) {
        el.plbdata.ro = false;
    }
    else {
        el.plbdata.ro = true;
    }

    if ((ci.ot == undefined) || (ci.ot != 1)) {
        el.plbdata.ot = false;
    }
    else {
        el.plbdata.ot = true;
    }

    if ((ci.ae == undefined) || (ci.ae != 1)) {
        el.plbdata.ae = false;
    }
    else {
        el.plbdata.ae = true;
       }

    if ((ci.sa == undefined) || (ci.sa != 1)) {
       	el.plbdata.sa = false;
       }
       else {
       	el.plbdata.sa = true;
       }
}

/*=============================================================================
Function:	EditNumPutString

Input:		object, stringto use
Output:	None

Purpose:  This function is used to put a string into the edit with trailing 0's.
*/

function EditNumCheck(el, str) {
    var pos;
    var fullLen;
    var intLen;
    var fracLen;
    var intDig;
    var fracDig;

    /* First validate the string */
    el.plbdata.sk = false;

    intDig = el.plbdata.dd;
    fracDig = el.plbdata.fd;

    if (el.plbdata.dpi) {
        for (pos = 0; pos < str.length; pos++) {
            if ((str[pos] == '.') || (str[pos] == el.plbdata.ld)) {
                break;
            }
        }

        if (pos == str.length) {
            intDig += fracDig;
            fracDig = 0;
        }
    }

    /* Trailing blanks */
    fullLen = str.length;

    /* Leading blanks and leading zero's */
    pos = 0;
    while ((pos != fullLen) && (str[pos] == 0x20)) {
        pos++;
    }

    /* Do we remove the negative sign */
    if ((str[pos] == '-') && (el.plbdata.am == false)) {
        return false;
    }

    intLen = 0;

    if (str[pos] == '-') {
        pos++;
        intLen++;
    }

    while ((pos != fullLen) && (str[pos] >= '0') && (str[pos] <= '9')) {
        intLen++;
        pos++;
    }

    if ((pos != fullLen) &&
	    (str[pos] != '.') &&
	    (str[pos] != el.plbdata.dc)) {
        return false;  /* Bad number end here */
    }

    fracLen = 0;
    if (pos != fullLen) {
        pos++;
        while ((pos != fullLen) && (str[pos] >= '0') && (str[pos] <= '9')) {
            fracLen++;
            pos++;
        }

        if (pos != fullLen) {
            return false;  /* Bad number end here */
        }
    }

    if (intLen > intDig) {
        return false;
    }

    if (fracLen > fracDig) {
        return false;
    }

    if (fracDig == 0) {
        if (intLen == intDig) {
            el.plbdata.sk = true;
        }
    }
    else if (fracLen == fracDig) {
        el.plbdata.sk = true;
    }
    return true;
}

function PlbEditNumDnFilter(evt) {
    var ci = evt.target.plbdata;
    var el = evt.target;
    var newVal;
    var charCode = (evt.which) ? evt.which : event.keyCode

    if (charCode == 8) { //  backspace
        if (el.selectionStart != el.selectionEnd) {
            newVal = el.value.substring(0, el.selectionStart) + el.value.substring(el.selectionEnd, el.value.length);
        }
        else if (el.selectionStart == 0) {
            newVal = el.value.substring(1, el.value.length);
        }
        else {
            newVal = el.value.substring(0, el.selectionStart-1) + el.value.substring(el.selectionEnd, el.value.length);
        }

        if (EditNumCheck(el, newVal) == false) {
                evt.preventDefault();     // Prevent character input
         }
    }

    if (charCode == 46) { // delete
        if (el.selectionStart != el.selectionEnd) {
            newVal = el.value.substring(0, el.selectionStart) + el.value.substring(el.selectionEnd, el.value.length);
        }
        else if (el.selectionStart != el.value.length) {
            newVal = el.value.substring(0, el.selectionStart) + el.value.substring(el.selectionEnd+1, el.value.length);
        }

        if (EditNumCheck(el, newVal) == false) {
            evt.preventDefault();     // Prevent character input
        }
    }
}


function PlbEditNumUpFilter(evt) {
    var ci = evt.target.plbdata;
    var el = event.target;

    if (ci.ae && ci.sk && (el.selectionStart == el.selectionEnd)
                  && (el.selectionStart == el.value.length)) {
     //   alert("Set to next focus");

    }
}

function PlbEditNumFilter(event) {

    var ci = event.target.plbdata;
    var el = event.target;
    var newVal;

    ci.sk = false;

    if (event.charCode) {

        if (ci.ro) {
            event.preventDefault();
            return;
        }

        if ( ci.fd == 0 && !ci.am ) {
            if ((((event.charCode < 48) || (event.charCode > 57)) && (event.charCode >= 32))) {
                event.preventDefault();     // Prevent character input
                return;
            }
        }
        else if ( ci.fd != 0 && ci.am) {
            if ((((event.charCode < 48) || (event.charCode > 57)) && (event.charCode >= 32)
          && (event.charCode != 45) && (event.charCode != ci.ld))) {
                event.preventDefault();     // Prevent character input
                return;
            }
        }
        else if ( ci.fd == 0 && ci.am ) {
            if ((((event.charCode < 48) || (event.charCode > 57)) && (event.charCode >= 32)
          && (event.charCode != 45))) {
                event.preventDefault();     // Prevent character input
                return;
            }
        }
        else {
            if ((((event.charCode < 48) || (event.charCode > 57)) && (event.charCode >= 32)
          && (event.charCode != ci.ld))) {
                event.preventDefault();     // Prevent character input
                return;
            }
        }

        if (ci.ot && (el.selectionStart == el.selectionEnd)) {
            newVal = el.value.substring(0, el.selectionStart) +
                 String.fromCharCode(event.charCode) + el.value.substring(el.selectionEnd + 1, el.value.length);
        }
        else {
            newVal = el.value.substring(0, el.selectionStart) +
                 String.fromCharCode(event.charCode) + el.value.substring(el.selectionEnd, el.value.length);
        }

        if (EditNumCheck(el, newVal) == false) {
            event.preventDefault();     // Prevent character input
        }
        else {
            if (ci.ot && (el.selectionStart == el.selectionEnd)) {
                el.selectionEnd += 1;
            }
        }
    }
}

function EditNumFixForDPI( el, str )
{
 var pos;
 var digits = 0;
 var zeros;
 var outStr;

	if( el.plbdata.fd == 0 )
	{
		return str;
	}

	for( pos = 0; pos < str.length; pos++ )
	{
		if( ( str[pos] == '.' ) ||
		    ( str[pos] == el.plbdata.ld ) )
		{
			return str; /* No fix needed */
        }

		digits++;
	}
	
	/* We need to add the implied decimal */
	if( digits <= el.plbdata.fd ) /* do we have enough digits ? */
	{
		zeros = el.plbdata.fd - digits;
		outStr = ".";
		pos = 1;
		while (zeros--) {
		    outStr += "0";
		}
		outStr += str;
	}
	else
	{
	    digits -= el.plbdata.fd;

	    outStr = str.substr(0, digits);
	    outStr += ".";
	    outStr += str.substr(digits, el.plbdata.fd);
	}

	return outStr;
}

/*=============================================================================
 Function:	EditNumPutString

 Input:		object, stringto use
 Output:	None

 Purpose:  This function is used to put a string into the edit with trailing 0's.
*/

function EditNumPutString( el, str, fSkipIfNoChange )
{
var pos;
var fullLen;
var	intLen;
var	fracLen;
var startPos;
var decPos;
var value;  
var fAddOne;
var fNeg = false;  
var outStr;

    if (el.plbdata.dpi) {
        fSkipIfNoChange = false;
        str = EditNumFixForDPI(el, str);
    }

	/* First validate the string */

	/* Trailing blanks */
    fullLen = str.length;

	/* Leading blanks and leading zero's */
    pos = 0;
	while( (pos != fullLen) && ( (str[pos] == 0x20) || (str[pos] == '0') ) ) {
		fSkipIfNoChange = false;
		pos++;
	}

	/* Do we remove the negative sign */
    if ((str[pos] == '-') && (el.plbdata.am != 1)) {
		fSkipIfNoChange = false;
		pos++;
	}

	intLen = 0;
	
	if( str[pos] == '-' ) {
		pos++;
		intLen++;
        fNeg = true;
    }
    startPos = pos;

	while( (pos != fullLen) && (str[pos] >= '0') && (str[pos] <= '9') ) {
		intLen++;
		pos++;
	}

	if( (pos != fullLen) && 
	    (str[pos] != '.') && 
	    (str[pos] != el.plbdata.dc) ) {
	    fullen = pos;  /* Bad number end here */
	}

	decPos = pos+1;
	fracLen = 0;
	if( pos != fullLen )
	{
		pos++;
		while( (pos != fullLen) && (str[pos] >= '0') && (str[pos] <= '9') ) {
			fracLen++;
			pos++;
		}

		if( pos != fullLen)
		{
		    fullen = pos;  /* Bad number end here */
		}
	}

	if (el.plbdata.dd == 0) {
	    intLen = 0;
	}
	else if (intLen > el.plbdata.dd) {
	    startPos += (intLen - el.plbdata.dd);
	    outStr = str.substr(startPos, el.plbdata.dd);
	    intLen = el.plbdata.dd;
	}
	else if (intLen == 0) {
	    if (fNeg) {
	        outStr = "-0";
	    }
	    else {
	        outStr = "0";
	    }
	}
	else {
	    if (fNeg) {
	        outStr = "-";
	        outStr += str.substr(startPos, ( intLen - 1 ) );
	    }
	    else {
	        outStr = str.substr(startPos, intLen);
	    }
	}

    if (el.plbdata.fd > 0) {
        outStr += el.plbdata.dc;

        if (fracLen > el.plbdata.fd) {
            fracLen = el.plbdata.fd;
        }

        if (fracLen > 0) {
            outStr += str.substr(decPos, fracLen);
        }

        while(fracLen< el.plbdata.fd) {
            outStr += '0';
            fracLen++;
        }
	}

	el.value = outStr;
}

function PlbEditNumFix(event) {

    EditNumPutString(event.target, event.target.value, true);
}

function PlbEditNum(ci) {
    var el = document.getElementById(ci.id);
    var pb = $("#" + ci.id);

    el.plbdata = new Object();
    el.plbdata.ld = ci.ld;
    el.plbdata.dc = ci.dc;
    el.plbdata.dd = ci.dd;
    el.plbdata.fd = ci.fd;
    el.plbdata.updn = ci.updn;
    el.plbdata.udmx = ci.udmx;
    el.plbdata.udmi = ci.udmi;
    el.plbdata.udic = ci.udic;

    if( ( ci.ro == undefined ) || ( ci.ro != 1 ) ) {
        el.plbdata.ro = false;
    }
    else {
        el.plbdata.ro = true;
    }

    if ((ci.ot == undefined) || (ci.ot != 1)) {
        el.plbdata.ot = false;
    }
    else {
        el.plbdata.ot = true;
    }

    
    if ((ci.ae == undefined) || (ci.ae != 1)) {
        el.plbdata.ae = false;
    }
    else {
        el.plbdata.ae = true;
    }

   if ((ci.sa == undefined) || (ci.sa != 1)) {
       	el.plbdata.sa = false;
     }
     else {
       	el.plbdata.sa = true;
     }

    if ((ci.dpi == undefined) || (ci.dpi != 1)) {
        el.plbdata.dpi = false;
    }
    else {
        el.plbdata.dpi = true;
    }

    if ((ci.am == undefined) || (ci.am != 1)) {
        el.plbdata.am = false;
    }
    else {
        el.plbdata.am = true;
    }

    if (ci.val != undefined) {
        EditNumPutString(el, ci.val, false);
    }
    else {
        EditNumPutString(el, "0", false);
    }

    if ((ci.updn == 1) || (ci.updn == 3)) {
        pb.spinner();

        pb.spinner("option", "min", ci.udmi);
        pb.spinner("option", "max", ci.udmx);
        pb.spinner("option", "step", ci.udic);
    }
}

function PlbEditDate(ci) {
    var el = document.getElementById(ci.id);
    var pb = $("#" + ci.id);

    el.plbdata = new Object();

    el.plbdata.resetz = false;
    el.plbdata.getdt = false;
    if ((ci.fmt != undefined) && (ci.fmt == 3)) {
        el.plbdata.isTime = true;
        pb.timespinner();
        pb.timespinner("value", new Date());
    }
    else {
        el.plbdata.isTime = false;
        pb.datepicker({ autoSize: true, changeMonth: true, changeYear: true });
        if (ci.formType != undefined) {
            var zorder = parseInt(pb.css("z-index"));
            switch (ci.formType) {
                case 1: zorder += 1100000; break;
                case 2: zorder += 1000000; break;
            }
            pb.css("z-index", zorder);
             pb.datepicker('option', { beforeShow: function () {
                if (el.plbdata.curDate != undefined) {
                    pb.datepicker('setDate', el.plbdata.curDate);
                    pb.datepicker('option', 'defaultDate', el.plbdata.curDate);
                }
               } });
               pb.datepicker('option', { onClose: function (dt) {
                   if (el.plbdata.getdt) {
                       var m = $("#ui-datepicker-div .ui-datepicker-month :selected").val();
                       var y = $("#ui-datepicker-div .ui-datepicker-year :selected").val();
                       try {
                           if (el.plbdata.curDate != undefined) {
                               el.plbdata.curDate = $.datepicker.parseDate(ci.format, dt);
                           }
                           else {
                               var curDate = $.datepicker.parseDate(ci.format, dt);
                           }
                       }
                       catch (exception) {
                           el.plbdata.curDate = new Date(y, m, 1);
                       }
                   }
               }
               });
        }
        else {
            el.plbdata.resetz = true;
            pb.datepicker('option', { beforeShow: function () {
                var zorder = parseInt(pb.css("z-index"));
                zorder += 1000000;
                if (el.plbdata.curDate != undefined) {
                    pb.datepicker('setDate', el.plbdata.curDate);
                    pb.datepicker('option', 'defaultDate', el.plbdata.curDate);
                }
                pb.css("z-index", zorder); } });
           pb.datepicker('option', { onClose: function ( dt ) {
               var zorder = parseInt(pb.css("z-index"));
            if (zorder >= 1000000) {
                zorder -= 1000000
            }
            if (el.plbdata.getdt) {
                var m = $("#ui-datepicker-div .ui-datepicker-month :selected").val();
                var y = $("#ui-datepicker-div .ui-datepicker-year :selected").val();
                try {
                        if (el.plbdata.curDate != undefined) {
                            el.plbdata.curDate = $.datepicker.parseDate(ci.format, dt);
                        }
                        else {
                            var curDate = $.datepicker.parseDate(ci.format, dt);
                        }
                    }
                catch (exception) {
                    el.plbdata.curDate = new Date(y,m,1);
                }
            }
            pb.css("z-index", zorder); } });
        }

        if (ci.fmt != undefined) {
            switch (ci.fmt) {
                case 0: break;
                case 1: pb.datepicker("option", "dateFormat", "DD, MM d, yy"); break;
                case 2: pb.datepicker("option", "dateFormat", "mm/dd/y"); break;
                case 4:
                    if (ci.format != undefined) {
                        pb.datepicker("option", "dateFormat", ci.format);
                        el.plbdata.getdt = true;
                    }
                    break;
            }
        }

        if (ci.fmt != undefined) {
            switch (ci.cmd) {
                case 1: pb.datepicker("setDate", new Date());
                    break;
            }
        }

        if (ci.minDate != undefined) {
            try {
                pb.datepicker("option", "minDate", $.datepicker.parseDate("yymmdd", ci.minDate));
            }
            catch (exception) {
            }
        }

        if (ci.maxDate != undefined) {
            try {
                pb.datepicker("option", "maxDate", $.datepicker.parseDate("yymmdd", ci.maxDate));
            }
            catch (exception) {
            }
        }
    }
}

function PlbDlist(ci) {
    var el = document.getElementById(ci.id);
    var pb = $("#" + ci.id);
    var v;

    el.plbdata = new Object();

    if (ci.st != undefined && ci.st == 1) {
        v = pb.val();
        el.plbdata.sorted = true;

        // sort the options and select the value that was saved
        pb.html($("#" + ci.id + " option").sort(function (a, b) {
            return a.text == b.text ? 0 : a.text < b.text ? -1 : 1;
        }));

        pb.val(v);
    }
    else {
        el.plbdata.sorted = false;
    }
}

function PlbApiTest( p1 ) { 

    return p1;
}

function PlbApiTest1(p1) {

    return JSON.stringify(p1);
}

