*........................................................................
.
. Example Program: ADDRWEB.PLS
.
. This program demonstrats a PLB program that can be executed via the
. Web Server.
.
. This program is a simple name	and address database program.  A Form 
. generated by PLBDSIGN.EXE provides the user interface.  The user is 
. allowed to add, modify, and delete entries from the address file.  
. Additionally,	Next and Previous buttons allow	browsing the file.
.
. This host program contains the Address file definitions, some	commonly
. used variables, the code to load and activate	the form and common 
. subroutines.	Additional code	may be found within the	form file itself. 
.
. To examine the form file, execute the	PLBDSIGN program and open the form
.  ADDRFORM.PWF.
.
. Copyright @ 2013, Sunbelt Computer Systems, Inc.
. All Rights Reserved.
.........................................................................
.
.Address File Record Definition
.
A	RECORD
NAME	DIM	 50
COMPANY	DIM	 50
ADDRESS	DIM	 50
CITY	DIM	 50
PHONE	DIM	 50
	RECORDEND
*
.The Address File
.
ADDRESS	 IFILE
*
.A Commonly Used Variable
.
RESULT	 INTEGER   1
*
. A Collection Containing All of the EDITTEXT Objects on the Form
.
ETOBJS	 COLLECTION
*
.The Program's Form (Created via PLBDSIGN.EXE)
.
MAIN    PLFORM   ADDRFORM.PWF
.
*..........................................................................
.
.Execution Begins by Loading the Program's Form
.
	  FORMLOAD MAIN
*
.Construct a Collection	of the Edittext	Objects
. By combining the EDITTEXT Objects into a Collection we may act on them as 
.   as a group rather than one by one.
.
	 LISTINS   ETOBJS,Addr_Name_ET,Addr_Company_ET,Addr_Address_ET:
		    Addr_City_ET,Addr_Phone_ET
.
*
.Wait for an Event to Occur
.
	LOOP
	 WAITEVENT
	REPEAT
*............................................................................
.
.Transfer the record variables'	contents into the EDITTEXT objects
.
SETDATA
	  SETPROP      Addr_Name_ET,TEXT=A.NAME
	  SETPROP      Addr_Company_ET,TEXT=A.COMPANY
	  SETPROP      Addr_Address_ET,TEXT=A.ADDRESS
	  SETPROP      Addr_City_ET,TEXT=A.CITY
	  SETPROP      Addr_Phone_ET,TEXT=A.PHONE
	  RETURN
*
.Transfer the EDITTEXT object values into the record variables
.
GETDATA
	  GETPROP      Addr_Name_ET,TEXT=A.NAME
	  GETPROP      Addr_Company_ET,TEXT=A.COMPANY
	  GETPROP      Addr_Address_ET,TEXT=A.ADDRESS
	  GETPROP      Addr_City_ET,TEXT=A.CITY
	  GETPROP      Addr_Phone_ET,TEXT=A.PHONE
	  RETURN
*
.Enable	or disable the Next and	Previous buttons based upon the	current
. file position.  If there are records preceeding the current record, the
. Previous button will be enabled.  If there are records following the
. current record, the Next button will be enabled.
.
UPD_NP
.
.Begin by disabling both buttons
.
	 SETPROP   Addr_Next_B,ENABLED=0
	 SETPROP   Addr_Previous_B,ENABLED=0
*
.If there is no	current	record (the name field is null), we exit with the
. buttons disabled.
.
	 COUNT	   RESULT,A.NAME
	 RETURN	   IF ZERO
*
.Test for a following record
.
	 READ	   ADDRESS,A.NAME;;    Position	to the current record
	 READKS	   ADDRESS;;	       Attempt to read the next	record
	 IF	   NOT OVER	       If successful,
	 SETPROP   Addr_Next_B,ENABLED=1   Enable the Next Button
	 ENDIF
*
.Test for a preceeding record
.
	 READ	   ADDRESS,A.NAME;;    Position	to the current record
	 READKP	   ADDRESS;;	       Attempt to read the previous record
	 IF	   NOT OVER	       If successful,
	 SETPROP   Addr_Previous_B,ENABLED=1  Enable the Previous Button
	 ENDIF
.
	 RETURN			       Return to caller
*
. Exit Button
.
CloseAndExit
    STOP

*
. Disable ETOBS objects 
.
Disable_ETOBJS
    CALL  ETOBJS_ENABLED_FNC USING "0"
    RETURN
*
. Enable ETOBS objects 
.
Enable_ETOBJS
    CALL  ETOBJS_ENABLED_FNC USING "1"
    RETURN
*
. Enable or Disable EditText Objects until COLLECTION implemented. 
.
ETOBJS_ENABLED_FNC FUNCTION
nValue             FORM    2
                   ENTRY
.
    SETPROP  Addr_Name_ET,    ENABLED=nValue
    SETPROP  Addr_Company_ET, ENABLED=nValue
    SETPROP  Addr_Address_ET, ENABLED=nValue
    SETPROP  Addr_City_ET,    ENABLED=nValue
    SETPROP  Addr_Phone_ET,   ENABLED=nValue
.
    FUNCTIONEND
