/*Date: 230727 Ver: 10.5B*/
(function () {

	this.plbWebNamespace = this.plbWebNamespace || {};
	var ns = this.plbWebNamespace;
	var plbwebbasic;

	$.fn.sortSelect = function () {
		var op = this.children("option");
		op.sort(function (a, b) {
			return a.text > b.text ? 1 : -1;
		})
		return this.empty().append(op);
	}

	ns.initialize = function (progId) {
		var sMsg;

		plbwebbasic = new ns.PlbWebBasic();

		plbwebbasic.setProgId(progId);

		sMsg = new Object();
		sMsg.action = 1;
		sMsg.version = 230727;
		sMsg.cversion = 10503;
		sMsg.flags = 2;
		sMsg.height = screen.height;
		sMsg.width = screen.width;
		sMsg.innerHeight = Math.round(window.innerHeight);
		sMsg.innerWidth = Math.round(window.innerWidth);
		sMsg.colorDepth = screen.colorDepth;
		sMsg.appName = navigator.appName;
		sMsg.appVersion = navigator.appVersion;

		if (plbWebNamespace.initCordova != undefined) {
			plbwebbasic.setCordova(plbWebNamespace.initCordova(plbwebbasic));
			sMsg.flags += 1;
		}

		if (plbWebNamespace.initPlbMob != undefined) {
			plbwebbasic.setPlbMob(plbWebNamespace.initPlbMob(plbwebbasic));
		}

		if (progId == 0) {
			if (sessionStorage.plbAddr != undefined) {
				plbwebbasic.setCommAddr(sessionStorage.plbAddr);
			}
			else {
				plbwebbasic.setCommAddr('http://127.0.0.1:8081/');
			}
			sMsg.plcId = 1;
			if (sessionStorage.plbProg != undefined) {
				sMsg.prog = sessionStorage.plbProg;
			}
			if (sessionStorage.plbCid != undefined) {
				sMsg.cid = sessionStorage.plbCid;
			}
			if (sessionStorage.plbOpt != undefined) {
				sMsg.opt = sessionStorage.plbOpt;
			}
			sMsg.version += 0x1000000;
		}

		plbwebbasic.sendMsg(sMsg);

		window.onbeforeunload = plbwebbasic.confirmExit;

		window.oncontextmenu = function () {
			return true;
		}

		try {
			window.addEventListener("orientationchange", plbwebbasic.chgOrient);
		}

		catch (exception) { }

		try {
			window.addEventListener("message", plbwebbasic.pstMsg);
		}

		catch (exception) { }
	}

	ns.action = function (id, action, isDlg) {
		var el, id1;
		switch (action) {
			case 1: plbwebbasic.setupResize(id, isDlg); break;
			case 2: plbwebbasic.setupClose(id, isDlg); break;
			case 3: plbwebbasic.setupMove(id, isDlg); break;
			case 4: plbwebbasic.setupNumCe(id); break;
			case 5:
				el = document.getElementById(id);
				if ((el != null) && (el.plbdata.evtc != undefined)) {
					id1 = parseInt(id.slice(1, id.length));
					plbwebbasic.makeEvent(8, 3, 0x20, 0, 0, id, id1);
				}
				break;
		}
	}

	ns.fileEvt = function (id) {
		plbwebbasic.handleFile(id);
	}

	ns.PlbWebBasic = (function () {

		var eventQue;
		var keyAheadBuff;
		var eventWaitTimer;
		var genTimer;
		var eventEventNeedsSend = false;
		var progId = 0;
		var commAddr = '';
		var errUrl;
		var gMainScrn;
		var gDebugScrn;
		var cntSendMsg = 0;
		var ioCancel = false;
		var getlocTimer = false;
		var fNoSpecCode = false;
		var mainUiStyle = 0;
		var ioCanKey = 0;
		var curMenu = null;
		var curItUrl = null;
		var corRtns = null;
		var mobRtns = null;
		var curDt;
		var curForm = 0;
		var preBrwH = 0;
		var preBrwV = 0;
		var osA = false;
		var myResult;

		PlbWebBasic.prototype.corEvent = function (evMsg) {

			evMsg.action = 8;
			evMsg.et = 99981;

			eventQue.push(evMsg);
		}

		PlbWebBasic.prototype.jqEvent = function (ev) {
			var myEvent;
			var eData;

			eData = new Object();
			eData.type = ev.type;
			if (ev.data.plbid !== undefined) {
				eData.id = ev.data.plbid;
			}
			else {
				eData.id = ev.target.id;
			}
			eData.pageX = ev.pageX;
			eData.pageY = ev.pageY;
			eData.metaKey = ev.metaKey;
			eData.which = ev.which;
			eData.target = ev.currentTarget.id;

			if (ev.data.plbtab !== undefined) {
				eData.tab = ev.data.plbtab;
			}

			myEvent = new Object();
			myEvent.action = 8;
			myEvent.et = ev.data.et;
			myEvent.id = 0;
			myEvent.edata = JSON.stringify(eData);
			myEvent.name = ev.data.plbref;

			eventQue.push(myEvent);

			if (eventEventNeedsSend) {
				window.clearTimeout(eventWaitTimer);
				eventEventNeedsSend = false;
				PlbWebBasic.prototype.sendMsg(eventQue.shift());
			}
		}

		PlbWebBasic.prototype.makeEvent = function (action, et, ec, em, ev, name, id, v1, v2) {
			var myEvent;

			if ((et == 99984) && (eventQue.length > 0)) {
				myEvent = eventQue.pop();

				if ((myEvent.et != 99984) || (myEvent.id != id)) {
					eventQue.push(myEvent);
				}
			}

			myEvent = new Object();
			myEvent.action = action;
			myEvent.et = et;
			myEvent.ec = ec;
			myEvent.em = em;
			myEvent.ev = ev;
			myEvent.name = name;
			myEvent.id = id;

			if (v1 != undefined) {
				myEvent.v1 = v1;
			}

			if (v2 != undefined) {
				myEvent.v2 = v2;
			}

			eventQue.push(myEvent);

			if (eventEventNeedsSend) {
				window.clearTimeout(eventWaitTimer);
				eventEventNeedsSend = false;
				if (et == 99984) {
					window.setTimeout(function () { PlbWebBasic.prototype.sendMsg(eventQue.shift()) }, 10);
				}
				else {
					PlbWebBasic.prototype.sendMsg(eventQue.shift());
				}
			}
		}

		PlbWebBasic.prototype.chgOrient = function (evt) {
			var eMsg;
			var ww;
			var wh;

			if (osA) {
				ww = screen.width;
				wh = screen.height;
			}
			else {
				ww = window.innerWidth;
				wh = window.innerHeight;
			}

			if (evt == undefined) {
				evt = new Object();
			}
			evt.width = screen.width;
			evt.height = screen.height;

			if (ww > wh && (ww - wh) > 50) {
				evt.orient = "landscape";
				if (evt.width < evt.height) {
					evt.width = screen.height;
					evt.height = screen.width;
				}
			}
			else {
				evt.orient = "portrait";
			}

			eMsg = new Object();
			eMsg.event = 301;
			eMsg.edata = JSON.stringify(evt);
			PlbWebBasic.prototype.corEvent(eMsg);

		}

		PlbWebBasic.prototype.pstMsg = function (evt) {
			var eMsg;
			if ((evt.data !== undefined) && (evt.data.plbevent !== undefined)) {
				eMsg = new Object();
				eMsg.event = 302;
				evt.data.origin = evt.origin;
				eMsg.edata = JSON.stringify(evt.data);
				PlbWebBasic.prototype.corEvent(eMsg);
			}
		}

		PlbWebBasic.prototype.checkKeys = function (evt) {

			evt = (evt) ? evt : ((event) ? event : null);

			if (evt.charCode == ioCanKey) {
				ioCancel = true;
			}
		}

		PlbWebBasic.prototype.makeTabIntoEvent = function (evt) {
			var et;

			evt = (evt) ? evt : ((event) ? event : null);

			if (fNoSpecCode) {
				return;
			}

			if (evt.keyCode == 13) {
				if (document.activeElement.id != "C1D") {
					PlbWebBasic.prototype.makeEvent(8, 99987, 0x20, 0, 0, "etk", 0);
				}
			}

			if (evt.keyCode == 27) {
				PlbWebBasic.prototype.makeEvent(8, 99986, 0x20, 0, 0, "esc", 0);
			}

			if (evt.keyCode != 9) {
				return;
			}

			if (evt.shiftKey) {
				et = 99997;
			}
			else {
				et = 99996;
			}

			PlbWebBasic.prototype.makeEvent(8, et, 0x20, 0, 0, "tab", 0);

			evt.preventDefault();

		}

		PlbWebBasic.prototype.checkMenuUp = function (evt) {

			evt = (evt) ? evt : ((event) ? event : null);

			if ((curMenu != null) && (evt.button == 2)) {
				curMenu.hide();
				curMenu = null;
				PlbWebBasic.prototype.PlbMenuEvent(null, 5, 0);
			}
		}

		PlbWebBasic.prototype.checkWinResize = function () {
			if (eventEventNeedsSend) {
				if ((preBrwH != window.innerHeight) || (preBrwV != window.innerWidth)) {
					preBrwH = window.innerHeight;
					preBrwV = window.innerWidth;
					PlbWebBasic.prototype.makeEvent(8, 99985, 0x20, Math.round(window.innerWidth), Math.round(window.innerHeight), "brw", 0);
				}
			}
		}

		function PlbWebBasic() {

			eventQue = new Array();
			gMainScrn = new Object();
			gDebugScrn = new Object();
			keyAheadBuff = "";

			document.onkeydown = PlbWebBasic.prototype.makeTabIntoEvent;
			document.onkeypress = PlbWebBasic.prototype.checkKeys;
			document.onmousedown = PlbWebBasic.prototype.checkMenuUp;
			window.onresize = PlbWebBasic.prototype.checkWinResize;

			if (navigator.userAgent.match(/Android/i)) {
				osA = true;
			}
		}

		PlbWebBasic.prototype.setProgId = function (id) {
			progId = id;
		}

		PlbWebBasic.prototype.setCommAddr = function (id) {
			commAddr = id;
			if (commAddr.length >= 1 && commAddr[commAddr.length - 1] != '/') {
				commAddr += "/";
			}
		}

		PlbWebBasic.prototype.setCordova = function (cordovaRtns) {
			corRtns = cordovaRtns;
		}

		PlbWebBasic.prototype.setPlbMob = function (mobileRtns) {
			mobRtns = mobileRtns;
		}

		PlbWebBasic.prototype.screenSetup = function (rMsg, theScreen) {
			var fgLine;
			var bgLine;

			theScreen.inEscSeq1 = false;
			theScreen.inEscSeq2 = false;
			theScreen.cursorV = 1;
			theScreen.cursorH = 1;
			theScreen.RowsMax = rMsg.row;
			theScreen.ColsMax = rMsg.col;
			theScreen.escStrSize = 0;
			theScreen.escString = "         ";
			theScreen.cw = 8;
			theScreen.ch = 14;
			theScreen.line = " ";
			theScreen.lines = new Array();
			theScreen.fgc = new Array();
			theScreen.bgc = new Array();
			theScreen.curs = false;
			theScreen.fg = "0";
			theScreen.bg = "7";
			for (pos = 0; pos < theScreen.ColsMax; pos++) {
				theScreen.line += " ";
				fgLine += theScreen.fg;
				bgLine += theScreen.bg;
			}
			for (pos = 0; pos < theScreen.RowsMax; pos++) {
				theScreen.lines[pos] = theScreen.line;
				theScreen.fgc[pos] = fgLine;
				theScreen.bgc[pos] = bgLine;
			}
		}

		PlbWebBasic.prototype.progSetup = function (rMsg) {
			var el = document.getElementById("C1D");
			var cnv = document.getElementById("C2");
			var ctx = cnv.getContext("2d");
			var pos;

			PlbWebBasic.prototype.screenSetup(rMsg, gMainScrn);
			PlbWebBasic.prototype.screenSetup(rMsg, gDebugScrn);

			ctx.scale(1, 1);

			if (rMsg.dbgfnt == undefined) {
				ctx.font = '14px "Courier New"';
			}
			else {
				ctx.font = '14px "' + rMsg.dbgfnt + '"';
			}

			el.addEventListener("mousedown", function (event) { var el = document.getElementById("C1D"); el.focus(); }, false);
			el.addEventListener("keydown", function (event) { PlbWebBasic.prototype.keyinDown(event); }, false);
			el.addEventListener("keypress", function (event) { PlbWebBasic.prototype.keyinPress(event); }, false);
		}

		PlbWebBasic.prototype.keyinDown = function (evt) {
			var charCode = (evt.which) ? evt.which : event.keyCode;
			var el = document.getElementById("C1D");

			if (document.activeElement.id != el.id) {
				return;
			}

			if (charCode == 8) { //  backspace
				keyAheadBuff += "\b";
				evt.preventDefault();
			}

			if (charCode == 46) { // delete
				keyAheadBuff += "\b";
				evt.preventDefault();
			}

			if (charCode == 13) { // Enter
				keyAheadBuff += "\n";
				evt.preventDefault();
			}

			if ((charCode == 27) || (charCode == 45)
                || (charCode >= 33 && charCode <= 40)
                || (charCode >= 112 && charCode <= 123)) {
				keyAheadBuff += "\r";
				keyAheadBuff += String.fromCharCode(charCode);
				evt.preventDefault();
			}
		}

		PlbWebBasic.prototype.keyinPress = function (evt) {
			var el = document.getElementById("C1D");

			if (document.activeElement.id != el.id) {
				return;
			}

			if (evt.charCode >= 0x20) {
				keyAheadBuff += String.fromCharCode(evt.charCode);
			}
		}

		PlbWebBasic.prototype.setScrnClr = function (ctx, theClr) {
			switch (theClr) {
				case "0": ctx.fillStyle = "black"; break;
				case "1": ctx.fillStyle = "red"; break;
				case "2": ctx.fillStyle = "green"; break;
				case "3": ctx.fillStyle = "yellow"; break;
				case "4": ctx.fillStyle = "blue"; break;
				case "5": ctx.fillStyle = "magenta"; break;
				case "6": ctx.fillStyle = "cyan"; break;
				case "7": ctx.fillStyle = "white"; break;
			}
		}

		PlbWebBasic.prototype.initScrn = function (theScreen) {

			var el = document.getElementById("C1D");
			var cnv = document.getElementById("C2");
			var ctx = cnv.getContext("2d");

			PlbWebBasic.prototype.setScrnClr(ctx, theScreen.bg);
			ctx.fillRect(0, 0, theScreen.ColsMax * theScreen.cw, theScreen.RowsMax * theScreen.ch);
			ctx.lineWidth = 1;
			ctx.strokeStyle = "black";
			PlbWebBasic.prototype.setScrnClr(ctx, theScreen.fg);

			el.focus();

		}

		PlbWebBasic.prototype.putCharToScrnBuff = function (theScreen, theChar) {
			var cnv = document.getElementById("C2");
			var ctx = cnv.getContext("2d");
			var theLine;
			var theFgc;
			var theBgc;

			if (theScreen.cursorH > 0 && theScreen.cursorV > 0) {

				PlbWebBasic.prototype.setScrnClr(ctx, theScreen.bg);
				ctx.fillRect((theScreen.cursorH - 1) * theScreen.cw, (theScreen.cursorV - 1) * theScreen.ch, theScreen.cw, theScreen.ch);

				PlbWebBasic.prototype.setScrnClr(ctx, theScreen.fg);

				if (theScreen.curs) {
					ctx.fillRect((theScreen.cursorH - 1) * theScreen.cw, (theScreen.cursorV - 1) * theScreen.ch + 2, 2, theScreen.ch - 3);
				}
				else {
					ctx.fillText(theChar, (theScreen.cursorH - 1) * theScreen.cw, (theScreen.cursorV * theScreen.ch) - 2);
				}

				theLine = theScreen.lines[theScreen.cursorV - 1];
				theFgc = theScreen.fgc[theScreen.cursorV - 1];
				theBgc = theScreen.bgc[theScreen.cursorV - 1];

				theScreen.lines[theScreen.cursorV - 1] = theLine.slice(0, theScreen.cursorH - 1) + theChar + theLine.slice(theScreen.cursorH);
				theScreen.fgc[theScreen.cursorV - 1] = theFgc.slice(0, theScreen.cursorH - 1) + theScreen.fg + theFgc.slice(theScreen.cursorH);
				theScreen.bgc[theScreen.cursorV - 1] = theBgc.slice(0, theScreen.cursorH - 1) + theScreen.bg + theBgc.slice(theScreen.cursorH);

				if (theScreen.cursorH < theScreen.ColsMax) {
					theScreen.cursorH++;
				}
			}
		}

		PlbWebBasic.prototype.changeClr = function (theScreen) {
			if (theScreen.escStrSize == 0) {
				theScreen.fg = "0";
				theScreen.bg = "7";
				return;
			}

			if (theScreen.escStrSize != 2) {
				return;
			}

			if (theScreen.escString[0] == "3") /* Foreground color */
			{
				theScreen.fg = theScreen.escString[1];
			}
			else if (theScreen.escString[0] == '4') /* Background color */
			{
				theScreen.bg = theScreen.escString[1];
			}
		}

		PlbWebBasic.prototype.dispOneChar = function (theChar, theScreen) {
			var cnv = document.getElementById("C2");
			var ctx = cnv.getContext("2d");
			var pos;
			var savH;
			var savV;
			var savBg;
			var savFg;

			if (theChar == "%") {
				if (theScreen.inEscSeq1) {
					PlbWebBasic.prototype.putCharToScrnBuff(theScreen, "%");
				}
				theScreen.inEscSeq1 = true;
				theScreen.inEscSeq2 = false;
				return;
			}

			if (theScreen.inEscSeq1) {
				theScreen.inEscSeq1 = false;

				if (theChar == "[") {
					theScreen.inEscSeq2 = true;
					theScreen.escStrSize = 0;
					return;
				}
				else /* Add in the escape character to be displayed */
				{
					PlbWebBasic.prototype.putCharToScrnBuff(theScreen, "%");
				}
			}

			if (theScreen.inEscSeq2) {
				if ((theChar == ";") || (theChar == "?") || (theChar >= "0") && (theChar <= "9")) {
					if (theScreen.escStrSize == 0) {
						theScreen.escString = theChar;
						theScreen.escStrSize = 1;
					}
					else {
						theScreen.escString += theChar;
						theScreen.escStrSize++;
					}
					return;
				}
				else /* Found a terminating character */
				{
					theScreen.inEscSeq2 = false;

					switch (theChar) {
						case "h": /* Screen termination */
							return;
							break;

						case "H": /* Position cursor */
							if (theScreen.escStrSize > 0) {

								for (pos = 0; pos < theScreen.escStrSize; pos++) {
									if (theScreen.escString[pos] == ';') {
										break;
									}
								}

								if (pos != theScreen.escStrSize) {
									theScreen.cursorV = parseInt(theScreen.escString.slice(0, pos));
									theScreen.cursorH = parseInt(theScreen.escString.slice(pos + 1));
								}

								if (theScreen.cursorV < 1) {
									theScreen.cursorV = 1;
								}

								if (theScreen.cursorV > theScreen.RowsMax) {
									theScreen.cursorV = theScreen.RowsMax;
								}

								if (theScreen.cursorH < 1) {
									theScreen.cursorH = 1;
								}

								if (theScreen.cursorH > theScreen.ColsMax) {
									theScreen.cursorH = theScreen.ColsMax;
								}
							}
							else {
								theScreen.cursorH = 1;
								theScreen.cursorV = 1;
							}
							return;
							break;

						case "J": /* Erase screen */
							savV = theScreen.cursorV;
							savH = theScreen.cursorH;
							while (theScreen.cursorH < theScreen.ColsMax) {
								PlbWebBasic.prototype.putCharToScrnBuff(theScreen, " ");
							}
							PlbWebBasic.prototype.putCharToScrnBuff(theScreen, " ");
							while (theScreen.cursorV < theScreen.RowsMax) {
								theScreen.cursorV++;
								theScreen.cursorH = 1;
								while (theScreen.cursorH < theScreen.ColsMax) {
									PlbWebBasic.prototype.putCharToScrnBuff(theScreen, " ");
								}
								PlbWebBasic.prototype.putCharToScrnBuff(theScreen, " ");
							}
							theScreen.cursorH = savH;
							theScreen.cursorV = savV;
							return;
							break;

						case "K": /* Erase line */
							savH = theScreen.cursorH;
							while (theScreen.cursorH < theScreen.ColsMax) {
								PlbWebBasic.prototype.putCharToScrnBuff(theScreen, " ");
							}
							PlbWebBasic.prototype.putCharToScrnBuff(theScreen, " ");
							theScreen.cursorH = savH;
							return;
							break;

						case "l": /* Screen init */
							PlbWebBasic.prototype.initScrn(gMainScrn);
							return;
							break;

						case "m": /* Set color */
							PlbWebBasic.prototype.changeClr(theScreen);
							return;
							break;

						case "S": /* Roll up *R */
							savV = theScreen.cursorV;
							savH = theScreen.cursorH;
							savBg = theScreen.bg;
							savFg = theScreen.fg;
							for (theScreen.cursorV = 1; theScreen.cursorV < theScreen.RowsMax; theScreen.cursorV++) {
								theScreen.cursorH = 1;
								while (theScreen.cursorH < theScreen.ColsMax) {
									theScreen.bg = theScreen.bgc[theScreen.cursorV][theScreen.cursorH - 1];
									theScreen.fg = theScreen.fgc[theScreen.cursorV][theScreen.cursorH - 1];
									PlbWebBasic.prototype.putCharToScrnBuff(theScreen, theScreen.lines[theScreen.cursorV][theScreen.cursorH - 1]);
								}
							}
							theScreen.cursorH = 1;
							theScreen.bg = savBg;
							theScreen.fg = savFg;
							while (theScreen.cursorH < theScreen.ColsMax) {
								PlbWebBasic.prototype.putCharToScrnBuff(theScreen, " ");
							}
							theScreen.cursorH = savH;
							theScreen.cursorV = savV;
							return;
							break;

						case "T": /* Roll down *RD */savV = theScreen.cursorV;
							savH = theScreen.cursorH;
							savBg = theScreen.bg;
							savFg = theScreen.fg;
							for (theScreen.cursorV = theScreen.RowsMax; theScreen.cursorV >= 2; theScreen.cursorV--) {
								theScreen.cursorH = 1;
								while (theScreen.cursorH < theScreen.ColsMax) {
									theScreen.bg = theScreen.bgc[theScreen.cursorV - 2][theScreen.cursorH - 1];
									theScreen.fg = theScreen.fgc[theScreen.cursorV - 2][theScreen.cursorH - 1];
									PlbWebBasic.prototype.putCharToScrnBuff(theScreen, theScreen.lines[theScreen.cursorV - 2][theScreen.cursorH - 1]);
								}
							}
							theScreen.cursorV = 1;
							theScreen.cursorH = 1;
							theScreen.bg = savBg;
							theScreen.fg = savFg;
							while (theScreen.cursorH < theScreen.ColsMax) {
								PlbWebBasic.prototype.putCharToScrnBuff(theScreen, " ");
							}
							theScreen.cursorH = savH;
							theScreen.cursorV = savV;
							return;
							break;

						default:
							return;
							break;

					}
				}
			}

			switch (theChar) {

				case "\b": /* Backspace */
					if (theScreen.cursorH > 1) {
						theScreen.cursorH--;
					}
					break;

				case "\n": /* Line Feed */
					if (theScreen.cursorV < theScreen.RowsMax) {
						theScreen.cursorV++;
					}
					else {
						savV = theScreen.cursorV;
						savH = theScreen.cursorH;
						savBg = theScreen.bg;
						savFg = theScreen.fg;
						for (theScreen.cursorV = 1; theScreen.cursorV < theScreen.RowsMax; theScreen.cursorV++) {
							theScreen.cursorH = 1;
							while (theScreen.cursorH < theScreen.ColsMax) {
								theScreen.bg = theScreen.bgc[theScreen.cursorV][theScreen.cursorH - 1];
								theScreen.fg = theScreen.fgc[theScreen.cursorV][theScreen.cursorH - 1];
								PlbWebBasic.prototype.putCharToScrnBuff(theScreen, theScreen.lines[theScreen.cursorV][theScreen.cursorH - 1]);
							}
						}
						theScreen.cursorH = 1;
						theScreen.bg = savBg;
						theScreen.fg = savFg;
						while (theScreen.cursorH < theScreen.ColsMax) {
							PlbWebBasic.prototype.putCharToScrnBuff(theScreen, " ");
						}
						theScreen.cursorH = savH;
						theScreen.cursorV = savV;
					}
					break;

				case "\r": /* Carriage Return */
					theScreen.cursorH = 1;
					break;

				default: /* We have a simple character */
					PlbWebBasic.prototype.putCharToScrnBuff(theScreen, theChar);
					break;
			}
		}

		PlbWebBasic.prototype.mainDisp = function (rMsg) {
			var pos;

			for (pos = 0; pos < rMsg.str.length; pos++) {
				if (rMsg.dbg != undefined) {
					PlbWebBasic.prototype.dispOneChar(rMsg.str[pos], gDebugScrn);
				}
				else {
					PlbWebBasic.prototype.dispOneChar(rMsg.str[pos], gMainScrn);
				}
			}
		}

		PlbWebBasic.prototype.mainGetKey = function (rMsg, theScreen) {
			var el = document.getElementById("C1D");

			if (rMsg.timeleft == undefined) {
				el.focus();
				rMsg.timeleft = 2;
			}

			if ((rMsg.dbg == undefined) && (eventQue.length > 0)) {
				myResult = new Object();
				myResult.action = 10;
				myResult.data = "\rd";
				PlbWebBasic.prototype.sendMsg(myResult);
				return;
			}

			if ((rMsg.tsec > 0) && (rMsg.timeleft > 0) && (keyAheadBuff.length == 0)) {
				if (rMsg.nocur == undefined) {
					theScreen.curs = !theScreen.curs;
				}
				PlbWebBasic.prototype.putCharToScrnBuff(theScreen, " ");
				theScreen.cursorH--;
				rMsg.timeleft--;
				setTimeout(function () { PlbWebBasic.prototype.mainKey(rMsg); }, 500);
			}
			else {
				myResult = new Object();
				myResult.action = 10;
				myResult.data = keyAheadBuff;

				theScreen.curs = false;
				PlbWebBasic.prototype.putCharToScrnBuff(theScreen, " ");
				theScreen.cursorH--;

				keyAheadBuff = "";
				PlbWebBasic.prototype.sendMsg(myResult);
			}
		}

		PlbWebBasic.prototype.mainKey = function (rMsg) {
			if (rMsg.dbg != undefined) {
				PlbWebBasic.prototype.mainGetKey(rMsg, gDebugScrn);
			}
			else {
				PlbWebBasic.prototype.mainGetKey(rMsg, gMainScrn);
			}
		}

		PlbWebBasic.prototype.confirmExit = function () {
			var termEvent;

			termEvent = new Object();
			termEvent.action = 8;
			termEvent.et = 99998;
			termEvent.ec = 0x20;
			termEvent.em = 0;
			termEvent.ev = 0;
			termEvent.name = "term";
			termEvent.id = 0;

			if (eventEventNeedsSend) {
				window.clearTimeout(eventWaitTimer);
				eventEventNeedsSend = false;
				PlbWebBasic.prototype.termMsg(termEvent, true);
				return;
			}

			PlbWebBasic.prototype.termMsg({ action: 1 }, false);

		}

		PlbWebBasic.prototype.PlbProgComplete = function (msg) {
			window.onbeforeunload = null;

			if (corRtns != null) {
				corRtns.CorProgComplete(msg);
			}
			else {
				if (msg == undefined || msg.length == undefined || msg.length == 0) {
					location.replace("plbwebclose.html");
				}
				else {
					location.replace(msg);
				}
			}
		}

		PlbWebBasic.prototype.PlbAlertEvent = function (val) {
			PlbWebBasic.prototype.makeEvent(8, 99999, 0x20, 0, val, "alert", 0);
		}

		PlbWebBasic.prototype.PlbAlert = function (rMsg) {
			var el;
			var dlgName;

			if (mobRtns != null) {
				mobRtns.PlbAlert(rMsg);
				return;
			}

			if (rMsg.at == undefined) {
				rMsg.at = 1;
			}

			if (rMsg.title == undefined) {
				rMsg.title = " ";
			}

			el = document.getElementById("mb" + rMsg.at);

			if (el == null) {
				rMsg.at = 1;
				el = document.getElementById("mb1");
			}

			el.innerHTML = rMsg.value;

			dlgName = "#alertc";

			if (rMsg.at > 1) {
				dlgName += rMsg.at;
			}

			if (rMsg.at == 3) {
				if (screen.width <= 480) {
					$(dlgName).dialog({ resizable: false, height: "auto", modal: true, title: rMsg.title, position: { my: "left top", at: "left top", of: window },
						dialogClass: "no-close",
						buttons: {
							Yes: function () {
								$(this).dialog("close");
								PlbWebBasic.prototype.PlbAlertEvent(1);

							},
							No: function () {
								$(this).dialog("close");
								PlbWebBasic.prototype.PlbAlertEvent(2);

							},
							Cancel: function () {
								$(this).dialog("close");
								PlbWebBasic.prototype.PlbAlertEvent(3);
							}
						}

					});
				}
				else {
					$(dlgName).dialog({ resizable: false, height: "auto", modal: true, title: rMsg.title, dialogClass: "no-close",
						buttons: {
							Yes: function () {
								$(this).dialog("close");
								PlbWebBasic.prototype.PlbAlertEvent(1);

							},
							No: function () {
								$(this).dialog("close");
								PlbWebBasic.prototype.PlbAlertEvent(2);

							},
							Cancel: function () {
								$(this).dialog("close");
								PlbWebBasic.prototype.PlbAlertEvent(3);
							}
						}

					});
				}
			}
			else {
				if (screen.width <= 480) {
					$(dlgName).dialog({ resizable: false, height: "auto", modal: true, title: rMsg.title, position: { my: "left top", at: "left top", of: window },
						dialogClass: "no-close",
						buttons: {
							OK: function () {
								$(this).dialog("close");
								PlbWebBasic.prototype.PlbAlertEvent(1);

							}
						}

					});
				}
				else {
					$(dlgName).dialog({ resizable: false, height: "auto", modal: true, title: rMsg.title, dialogClass: "no-close",
						buttons: {
							OK: function () {
								$(this).dialog("close");
								PlbWebBasic.prototype.PlbAlertEvent(1);

							}
						}

					});
				}
			}

		}

		PlbWebBasic.prototype.PlbErrEvent = function () {
			PlbWebBasic.prototype.makeEvent(8, 99999, 0x20, 0, 0, "alert", 0);

		}

		PlbWebBasic.prototype.PlbProgError = function (errMsg) {
			var ed;
			var el = document.getElementById("errDet");

			if (el == null) {
				PlbWebBasic.prototype.PlbProgComplete(errUrl);
				return;
			}

			if (mobRtns != null) {
				mobRtns.PlbProgError(errMsg);
				return;
			}

			ed = document.getElementById("erd1");
			if (ed != null) {
				ed.innerHTML = errMsg.code;
			}
			ed = document.getElementById("erd2");
			if (ed != null) {
				ed.innerHTML = errMsg.addr;
			}
			ed = document.getElementById("erd3");
			if (ed != null) {
				ed.innerHTML = errMsg.scode;
			}
			ed = document.getElementById("erd4");
			if (ed != null && errMsg.extnd != undefined) {
				ed.innerHTML = errMsg.extnd;
			}
			ed = document.getElementById("erd5");
			if (ed != null && errMsg.pinfo != undefined) {
				ed.value = errMsg.pinfo;
			}
			ed = document.getElementById("erd6");
			if (ed != null && errMsg.fdata != undefined) {
				ed.value = errMsg.fdata;
			}

			$("#errDet").dialog({ resizable: false, height: 280, width: 400, modal: true, title: "Program Error",
				close: function (event, ui) { PlbWebBasic.prototype.PlbErrEvent(); },
				open: function (event, ui) { $(this).parent().focus(); },
				buttons: {
					"Hide/Show Details": function () {
						var height = $(this).dialog("option", "height");

						if (height == 280) {
							$(this).dialog("option", "height", 0);
						}
						else {
							$(this).dialog("option", "height", 280);
						}

					},
					"Stop": function () {
						$(this).dialog("close");
					}
				}
			});

		}

		PlbWebBasic.prototype.WaitEventTimeout = function (tmLeft) {

			if (eventEventNeedsSend) {

				if ((eventQue.length == 0) && (tmLeft > 0)) {
					if (tmLeft > 200) {
						eventWaitTimer = window.setTimeout(function () { PlbWebBasic.prototype.WaitEventTimeout(tmLeft - 200) }, 200);
					}
					else {
						eventWaitTimer = window.setTimeout(function () { PlbWebBasic.prototype.WaitEventTimeout(0) }, tmLeft);
					}
				}
				else {
					eventEventNeedsSend = false;

					if (eventQue.length > 0) {
						PlbWebBasic.prototype.sendMsg(eventQue.shift());
					}
					else {
						PlbWebBasic.prototype.sendMsg({ action: 2, result: 1 });
					}
				}
			}
		}


		PlbWebBasic.prototype.AddPlbSldEv = function (rMsg) {
			var pb = $("#" + rMsg.name);
			var val = 0;

			if (pb[0] != null) {
				val = pb.slider("option", "value");
			}

			PlbWebBasic.prototype.makeEvent(8, 3, 0x20, 0, val, rMsg.name, rMsg.id);
		}

		PlbWebBasic.prototype.AddPlbDtEv = function (rMsg, dt) {
			var pb = $("#" + rMsg.name);

			if (dt != pb[0].curDt) {
				pb[0].curDt = dt;
				PlbWebBasic.prototype.makeEvent(8, 3, 0x20, 0, 0, rMsg.name, rMsg.id);
			}
		}

		PlbWebBasic.prototype.AddPlbTabEv = function (event, ui, nam, evtVal) {
			var ev;
			var id;
			var pb = $("#" + nam);

			ev = pb.tabs("option", "active") + 1;
			id = parseInt(nam.slice(1, nam.length));

			PlbWebBasic.prototype.makeEvent(8, evtVal, 0x20, 0, ev, nam, id);
		}

		PlbWebBasic.prototype.AddPlbEvClick = function (rMsg, evt) {
			var ev;
			var el = document.getElementById(rMsg.name);
			var el1;

			if (el == null) {
				return;
			}

			ev = 0;

			if (el.checked != undefined) {
				if (el.checked == false) {
					ev = 1;
				}
			} else if (el.selectedIndex != undefined) {
				ev = el.selectedIndex + 1;
			}

			PlbWebBasic.prototype.makeEvent(8, rMsg.en, 0x20, 0, ev, rMsg.name, rMsg.id);

			if ((el.checked != undefined) && (el.prevClk != undefined) && el.prevClk) {
				evt.preventDefault();
			}
		}

		PlbWebBasic.prototype.AddPlbEvent = function (rMsg) {
			var ev;
			var el = document.getElementById(rMsg.name);

			if (el == null) {
				return;
			}

			ev = 0;

			if (el.checked != undefined) {
				if (el.checked == false) {
					ev = 1;
				}
			} else if (el.selectedIndex != undefined) {
				ev = el.selectedIndex + 1;
			}

			PlbWebBasic.prototype.makeEvent(8, rMsg.en, 0x20, 0, ev, rMsg.name, rMsg.id);
		}

		PlbWebBasic.prototype.AddPlbEvIn = function (rMsg) {
			var ev;
			var el = document.getElementById(rMsg.name);

			if (el == null) {
				return;
			}

			ev = 0;

			if (el.lastSize != 0 || el.value.length != 0) {
				el.lastSize = el.value.length;
				PlbWebBasic.prototype.makeEvent(8, rMsg.en, 0x20, 0, ev, rMsg.name, rMsg.id);
			}
		}

		PlbWebBasic.prototype.GetObjPos = function (element) {
			var xPosition = 0;
			var yPosition = 0;

			while (element) {
				xPosition += (element.offsetLeft + element.clientLeft) - element.scrollLeft;
				yPosition += (element.offsetTop + element.clientTop) - element.scrollTop;
				element = element.offsetParent;
			}
			return { x: xPosition, y: yPosition };
		}


		PlbWebBasic.prototype.AddPlbMseEvent = function (rMsg, evt) {
			var ev, em;
			var parPos, posX, posY;
			var el = document.getElementById(rMsg.form);

			if (el == null) {
				return;
			}

			evt = (evt) ? evt : ((event) ? event : null);

			parPos = PlbWebBasic.prototype.GetObjPos(evt.currentTarget);
			
			if( evt.touches && ( evt.touches.length == 1 ) ) {
				var touch = evt.touches[0]; 
				posX = Math.round((touch.pageX + window.pageXOffset) - parPos.x);
				posY = Math.round((touch.pageY + window.pageYOffset) - parPos.y);
				evt.preventDefault();
			}
			else {
				posX = Math.round((evt.clientX + window.pageXOffset) - parPos.x);
				posY = Math.round((evt.clientY + window.pageYOffset) - parPos.y);
			}
			
			em = 0;
			ev = (posX * 10000) + posY;

			if (evt.altKey) {
				em = 1;
			}

			if (evt.ctrlKey) {
				em += 2;
			}

			if (evt.shiftKey) {
				em += 4;
			}

			if (evt.button == 0) {
				em += 8;
			}

			if (evt.button == 2) {
				em += 16;
			}

			if (rMsg.ap == undefined) {
				evt.stopPropagation();
			}

			PlbWebBasic.prototype.makeEvent(8, rMsg.en, 0x20, em, ev, rMsg.name, rMsg.id);

		}

		PlbWebBasic.prototype.AddPlbKeyEvent = function (rMsg, event) {
			var em = 0;

			if ((event.charCode == 0) || (event.charCode == 13)) {
				return;
			}

			if (event.altKey) {
				em = 1;
			}

			if (event.ctrlKey) {
				em += 2;
			}

			if (event.shiftKey) {
				em += 4;
			}

			PlbWebBasic.prototype.makeEvent(8, rMsg.en, event.charCode, em, 0, rMsg.name, rMsg.id);
		}

		PlbWebBasic.prototype.AddPlbKeyVEvent = function (rMsg, evt) {
			var em = 0;
			var charCode = (evt.which) ? evt.which : event.keyCode;

			if (evt.altKey) {
				em = 1;
			}

			if (evt.ctrlKey) {
				em += 2;
			}

			if ((em == 0) && (charCode >= 0x30) && (charCode <= 0x7A)) {
				return;
			}

			if ((charCode == 9) || (charCode == 0x20) || (charCode == 16) || (charCode == 17) || (charCode == 18)) {
				return;
			}

			if (evt.shiftKey) {
				em += 4;
			}

			PlbWebBasic.prototype.makeEvent(8, rMsg.en, 0x20, em, charCode, rMsg.name, rMsg.id);
		}

		PlbWebBasic.prototype.SetListEvents = function (rMsg) {
			$("#" + rMsg.name + " ul li").bind("dblclick", function (evt) {
				var em = 0;
				if (evt.altKey) {
					em = 1;
				}
				if (evt.ctrlKey) {
					em += 2;
				}
				if (evt.shiftKey) {
					em += 4;
				}
				if (evt.button == 1) {
					em += 8;
				}
				if (evt.button == 2) {
					em += 16;
				}

				PlbWebBasic.prototype.makeEvent(8, 99982, 0x20, em, 1, $(this).attr('id'), 0);
			});

			$("#" + rMsg.name + " ul li").bind("click", function (evt) {
				var em = 0;
				if (evt.altKey) {
					em = 1;
				}
				if (evt.ctrlKey) {
					em += 2;
				}
				if (evt.shiftKey) {
					em += 4;
				}
				if (evt.button == 1) {
					em += 8;
				}
				if (evt.button == 2) {
					em += 16;
				}

				PlbWebBasic.prototype.makeEvent(8, 99982, 0x20, em, 0, $(this).attr('id'), 0);
			});
		}

		PlbWebBasic.prototype.eventReg = function (rMsg) {
			var el = document.getElementById(rMsg.name);

			if (el == null) {
				return;
			}

			switch (rMsg.en) {
				case 3:
					if (el.plbdata != undefined) {
						el.plbdata.evtc = true;
					}
					if (rMsg.sp != undefined) {
						el.lastSize = el.value.length;
						el.addEventListener("input", function () { PlbWebBasic.prototype.AddPlbEvIn(rMsg) }, false);
					}
					else {
						el.addEventListener("change", function () { PlbWebBasic.prototype.AddPlbEvent(rMsg) }, false);
					}
					break;
				case 4:
					if (rMsg.sp != undefined) {
						el.addEventListener("change", function () { PlbWebBasic.prototype.AddPlbEvent(rMsg) }, false);
					}
					else {
						if (rMsg.prec != undefined) {
							el.prevClk = true;
						}
						if (rMsg.lte != undefined) {
							PlbWebBasic.prototype.SetListEvents(rMsg);
						}
						else {
							el.addEventListener("click", function (event) { PlbWebBasic.prototype.AddPlbEvClick(rMsg, event) }, false);
						}
					}
					break;
				case 6:
					el.addEventListener("dblclick", function () { PlbWebBasic.prototype.AddPlbEvent(rMsg) }, false);
					break;
				case 10:
					el.addEventListener("keypress", function (event) { PlbWebBasic.prototype.AddPlbKeyEvent(rMsg, event) }, false);
					el.addEventListener("keyup", function (event) { PlbWebBasic.prototype.AddPlbKeyVEvent(rMsg, event) }, false);
					break;
				case 13:
					el.addEventListener("touchstart", function (event) { PlbWebBasic.prototype.AddPlbMseEvent(rMsg, event) }, false);
					el.addEventListener("mousedown", function (event) { PlbWebBasic.prototype.AddPlbMseEvent(rMsg, event) }, false);
					break;
				case 14:
					el.addEventListener("touchend", function (event) { PlbWebBasic.prototype.AddPlbMseEvent(rMsg, event) }, false);
					el.addEventListener("mouseup", function (event) { PlbWebBasic.prototype.AddPlbMseEvent(rMsg, event) }, false);
					break;
				case 15:
					el.addEventListener("touchmove", function (event) { PlbWebBasic.prototype.AddPlbMseEvent(rMsg, event) }, false);
					if (rMsg.mm == undefined) {
						el.addEventListener("mouseover", function (event) { PlbWebBasic.prototype.AddPlbMseEvent(rMsg, event) }, false);
					}
					else {
						el.addEventListener("mousemove", function (event) { PlbWebBasic.prototype.AddPlbMseEvent(rMsg, event) }, false);
					}
					break;
				case 17:
					el.addEventListener("resize", function () { PlbWebBasic.prototype.AddPlbEvent(rMsg) }, false);
					break;

			}
		}

		PlbWebBasic.prototype.eventUnReg = function (rMsg) {
			var el = document.getElementById(rMsg.name);

			if (el == null) {
				return;
			}

			switch (rMsg.en) {
				case 4:
					el.prevClk = false;
					break;
			}
		}

		PlbWebBasic.prototype.handleFocus = function (elName) {
			var el = document.getElementById(elName);

			if (el == null) {
				return;
			}

			fNoSpecCode = false;

			if ((el.plbdata !== undefined) && (el.plbdata.sa !== undefined)
		            && el.plbdata.sa) {
				if ('selectionStart' in el) {
					el.selectionStart = 0;
					el.selectionEnd = el.value.length;
				}
			}

			PlbWebBasic.prototype.makeEvent(8, 99995, 0x20, 0, 0, elName, 0);
		}

		PlbWebBasic.prototype.setupFocus = function (el) {
			el.addEventListener("focus", function () { PlbWebBasic.prototype.handleFocus(el.id) }, false);
			if ((el.type == "submit") || (el.type == "button")) {
				el.addEventListener("click", function () { el.focus() }, false);
			}
		}

		PlbWebBasic.prototype.setupFoc1 = function (el) {
			el.addEventListener("focus", function () { fNoSpecCode = true; }, false);
		}

		PlbWebBasic.prototype.handleResize = function (elName, ui) {
			var el = $('#' + elName);
			var val;

			if (el[0] == null) {
				return;
			}

			PlbWebBasic.prototype.makeEvent(8, 99993, 0x20, Math.round(ui.size.width), Math.round(ui.size.height), elName, 0, Math.round(ui.originalSize.height), Math.round(ui.originalSize.width));
		}

		PlbWebBasic.prototype.setupResize = function (id, isDlg) {
			if (isDlg) {
				$("#" + id).on("dialogresizestop", function (event, ui) { PlbWebBasic.prototype.handleResize(id, ui) });
			}
			else {
				$("#" + id).on("resizestop", function (event, ui) { PlbWebBasic.prototype.handleResize(id, ui) });
			}
		}

		PlbWebBasic.prototype.handleMove = function (elName, ui) {
			var el = $('#' + elName);

			if (el[0] == null) {
				return;
			}

			PlbWebBasic.prototype.makeEvent(8, 99988, 0x20, Math.round(ui.position.left), Math.round(ui.position.top), elName, 0);
		}

		PlbWebBasic.prototype.setupMove = function (id, isDlg) {
			if (isDlg) {
				$("#" + id).on("dialogdragstop", function (event, ui) { PlbWebBasic.prototype.handleMove(id, ui) });
			}
			else {
				$("#" + id).on("dragstop", function (event, ui) { PlbWebBasic.prototype.handleMove(id, ui) });
			}
		}

		PlbWebBasic.prototype.setupNumCe = function (nam) {
			var pb = $("#" + nam);

			if (pb[0] != null) {
				pb.on("spin", function (event, ui) {
					var el = document.getElementById(nam);
					var id;
					if ((el != null) && (el.plbdata.evtc != undefined)) {
						id = parseInt(nam.slice(1, nam.length));
						PlbWebBasic.prototype.makeEvent(8, 3, 0x20, 0, 0, nam, id);
					}
				});
			}
		}

		PlbWebBasic.prototype.handleClose = function (elName) {
			var el = document.getElementById(elName);

			if (el == null) {
				return;
			}

			PlbWebBasic.prototype.makeEvent(8, 99992, 0x20, 0, 0, elName, 0);
		}

		PlbWebBasic.prototype.setupClose = function (id) {
			$("#" + id).on("dialogbeforeclose", function (event, ui) { PlbWebBasic.prototype.handleClose(id); return event.target.plbdata.canclose; });
		}

		PlbWebBasic.prototype.handleFile = function (id) {
			var el = document.getElementById(id);
			var flNam = new Array();
			var flTyp = new Array();
			var flSz = new Array();
			var pos;
			if (el != null) {
				if (el.files.length == 0) {
					PlbWebBasic.prototype.makeEvent(8, 99984, 0x20, el.files.length, flNam, id, 0, flTyp, flSz);
				}
				for (pos = 0; pos < el.files.length; pos++) {
					flNam[pos] = el.files[pos].name;
					flTyp[pos] = el.files[pos].type;
					flSz[pos] = el.files[pos].size;
					PlbWebBasic.prototype.makeEvent(8, 99984, 0x20, el.files.length, flNam, id, 0, flTyp, flSz);
				}
			}
		}

		PlbWebBasic.prototype.methDlist = function (rMsg) {
			var el = document.getElementById(rMsg.name);
			var newOpt;
			var lastOpt;
			var curPos;
			var str;
			var doSel;

			if (el == null) {
				return true;
			}

			if (rMsg.str != undefined) {
				rMsg.str = rMsg.str.replace(/  /g, " &nbsp;");
				rMsg.str = rMsg.str.replace(/</g, "&lt;");
				rMsg.str = rMsg.str.replace(/>/g, "&gt;");
			}

			switch (rMsg.dwid) {
				case 1:
					if (rMsg.val == undefined) {
						newOpt = new Option(rMsg.str, 0);
					}
					else {
						newOpt = new Option(rMsg.str, rMsg.val);
					}

					newOpt.innerHTML = rMsg.str;

					if ((rMsg.pos != undefined) && (rMsg.pos < 0)) {
						rMsg.pos = el.options.length + 1;
					}

					if ((rMsg.pos == undefined) || (rMsg.pos >= el.options.length)) {
						el.options[el.options.length] = newOpt;
					}
					else {
						lastOpt = new Option();

						el.options[el.options.length] = lastOpt;

						for (curPos = el.options.length - 1; curPos > rMsg.pos; curPos--) {
							el.options[curPos].text = el.options[curPos - 1].text;
							el.options[curPos].value = el.options[curPos - 1].value;
						}
						el.options[curPos] = newOpt;
					}

					if ((el.plbdata != undefined) && (el.plbdata.sorted != undefined)) {
						if (el.plbdata.sorted) {
							if (el.options.length > 1) {
								$("#" + rMsg.name).sortSelect();
							}
						}
					}
					break;
				case 2:
					if (rMsg.pos == 0) {
						while (el.options.length) {
							el.remove(0);
						}
					}
					else {
						el.remove(rMsg.pos - 1);
					}
					break;
				case 3:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;

					if (rMsg.pos == 0) {
						if (el.selectedIndex >= 0)
							myResult.str = el.options[el.selectedIndex].text;
					}
					else {
						if (rMsg.pos <= el.options.length)
							myResult.str = el.options[rMsg.pos - 1].text;
					}
					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
					break;

				case 4:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;

					switch (rMsg.typ) {
						case 0: myResult.val = el.selectedIndex + 1; break;
						case 1: myResult.val = el.options.length; break;
						case 2:
							myResult.val = 0;
							for (curPos = 0; curPos < el.options.length; curPos++) {
								if (el.options[curPos].selected) {
									myResult.val++;
								}
							}
							break;
						case 3:
							myResult.val = 0;
							for (curPos = (rMsg.pos - 1); curPos < el.options.length; curPos++) {
								if (el.options[curPos].selected) {
									myResult.val = curPos + 1;
									break;
								}
							}
							break;
						case 4:
							if (rMsg.pos > 0 && rMsg.pos <= el.options.length) {
								if (el.options[rMsg.pos - 1].selected) {
									myResult.val = rMsg.pos;
								}
								else {
									myResult.val = 0;
								}
							}
							else {
								myResult.val = 0xFFFFFFFF;
							}
							break;
						default: myResult.val = 0; break;
					}
					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
					break;
				case 5:
					if (rMsg.set == undefined) {
						el.selectedIndex = rMsg.val - 1;
					}
					else {
						if (rMsg.val > 0) {
							doSel = true;
						}
						else {
							doSel = false;
						}
						if (rMsg.item > 0 && rMsg.item <= el.options.length) {
							el.options[rMsg.item - 1].selected = doSel;
						}
						else if (rMsg.item == 0) {
							for (curPos = 0; curPos < el.options.length; curPos++) {
								el.options[curPos].selected = doSel;
							}
						}
					}
					break;
				case 6:
					if (rMsg.pos < el.options.length) {
						el.options[rMsg.pos].innerHTML = rMsg.str;
					}
					break;
				case 7:
					if (rMsg.pos < el.options.length) {
						el.options[rMsg.pos].value = rMsg.val;
					}
					break;
				case 8:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;

					if ((rMsg.pos < 0) || (rMsg.pos > el.options.length)) {
						myResult.result = -1;
					}
					else {
						myResult.val = el.options[rMsg.pos].value;
					}

					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
				case 9:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;

					rMsg.str = rMsg.str.toUpperCase();

					for (curPos = rMsg.item; curPos < el.options.length; curPos++) {
						str = el.options[curPos].text.toUpperCase();
						if (rMsg.act == 2) {
							if (str == rMsg.str) {
								break;
							}
						}
						else {
							if (str.indexOf(rMsg.str) == 0) {
								break;
							}
						}
					}

					if ((curPos >= el.options.length) && (rMsg.item > 0)) {
						for (curPos = 0; curPos < rMsg.item; curPos++) {
							str = el.options[curPos].text.toUpperCase();
							if (rMsg.act == 2) {
								if (str == rMsg.str) {
									break;
								}
							}
							else {
								if (str.indexOf(rMsg.str) == 0) {
									break;
								}
							}
						}
					}
					else {
						rMsg.item = el.options.length;
					}

					if (curPos >= rMsg.item) {
						curPos = 0;
					}
					else {
						if (rMsg.act == 3)
							el.selectedIndex = curPos;
						curPos += 1;
					}

					myResult.res = curPos;

					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
					break;

				case 10:
					if (el.plbdata == undefined) {
						el.plbdata = new Object();

					}
					if (rMsg.val == 0) {
						el.plbdata.sorted = false;
					}
					else {
						el.plbdata.sorted = true;
					}
					if (el.plbdata.sorted) {
						if (el.options.length > 1) {
							$("#" + rMsg.name).sortSelect();
						}
					}
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.methEdit = function (rMsg) {
			var el = document.getElementById(rMsg.name);
			var newOpt;
			var lastOpt;
			var curPos;
			var doSel;

			if (el == null) {
				return true;
			}

			switch (rMsg.dwid) {
				case 1:
					if ('selectionStart' in el) {
						if ($("#" + rMsg.name).is(":focus")) {
							el.selectionStart = 0;
							el.selectionEnd = el.value.length;
						}
					}
					break;
				case 2:
					if ('selectionStart' in el) {
						if (rMsg.ss != undefined) {
							el.selectionStart = rMsg.ss;
						}
						if (rMsg.se != undefined) {
							el.selectionEnd = rMsg.se;
						}
					}
					break;
				case 3:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;

					if ('selectionStart' in el) {
						myResult.ss = el.selectionStart;
						myResult.se = el.selectionEnd;

						if (rMsg.pos == 0) {
							myResult.str = el.value;
						}
						else if (el.selectionStart != el.selectionEnd) {
							myResult.sel = el.value.substring(el.selectionStart, el.selectionEnd);
						}
					}

					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
					break;

				case 4:
					if (rMsg.pos == 0) {
						el.value = rMsg.str;
					}
					else {
						if ('selectionStart' in el) {
							// check whether some text is selected 
							if (el.selectionStart != el.selectionEnd) {
								var newText = el.value.substring(0, el.selectionStart) +
                                             rMsg.str + el.value.substring(el.selectionEnd);
								el.value = newText;
							}
						}
					}
					break;
				case 5:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;
					myResult.val = 0;

					switch (rMsg.typ) {
						case 0: myResult.val = el.value.length; break;
						case 1: if ('selectionStart' in el) {
								myResult.val = el.selectionStart;
							}
							break;
						case 2: if ('selectionEnd' in el) {
								myResult.val = el.selectionEnd;
							}
							break;
						default: myResult.val = 0; break;
					}
					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
					break;

				case 6:
					if (rMsg.pos == 0) {
						el.value += rMsg.str;
					}
					else {
						if ('selectionStart' in el) {
							var newText = el.value.substring(0, el.selectionEnd) +
                                             rMsg.str + el.value.substring(el.selectionEnd);
							el.value = newText;
						}
					}
					break;

				case 7:
					if (rMsg.ae != undefined) {
						el.plbdata.ae = (rMsg.ae == 0) ? false : true;
					}
					if (rMsg.ot != undefined) {
						el.plbdata.ot = (rMsg.ot == 0) ? false : true;
					}
					if (rMsg.sa != undefined) {
						el.plbdata.sa = (rMsg.sa == 0) ? false : true;
					}
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.getRect = function (rMsg) {
			var parPos;
			var el = document.getElementById(rMsg.name);
			var frm;
			var el1 = $('#' + rMsg.name);

			myResult = new Object();
			myResult.action = 2;
			myResult.result = 0;

			if (el != null) {
				parPos = PlbWebBasic.prototype.GetObjPos(el);
				myResult.result = 4;
				myResult.l = Math.round(parPos.x);
				myResult.t = Math.round(parPos.y);

				if (rMsg.form != undefined) {
					el = document.getElementById(rMsg.form);
					if (el != null) {
						parPos = PlbWebBasic.prototype.GetObjPos(el);
						myResult.l -= Math.round(parPos.x);
						myResult.t -= Math.round(parPos.y);
					}
				}

				myResult.w = Math.round(el1.width());
				myResult.h = Math.round(el1.height());
			}

			PlbWebBasic.prototype.sendMsg(myResult);

		}

		PlbWebBasic.prototype.setIoCan = function () {
			ioCancel = true;
		}

		PlbWebBasic.prototype.getIoCan = function (rMsg) {
			var el;

			myResult = new Object();
			myResult.action = 2;
			myResult.result = 0;
			if (rMsg.ic == undefined) {
				if (rMsg.name == undefined) {
					myResult.val = ioCancel ? 1 : 0;
				}
				else {
					el = document.getElementById(rMsg.name);

					if (el != null) {
						if (rMsg.rem == undefined) {
							el.addEventListener("click", PlbWebBasic.prototype.setIoCan);
						}
						else {
							el.removeEventListener("click", PlbWebBasic.prototype.setIoCan);
						}
					}
				}
			}
			else {
				ioCancel = false;
				ioCanKey = rMsg.ic;
			}

			PlbWebBasic.prototype.sendMsg(myResult);
		}

		PlbWebBasic.prototype.methEditNum = function (rMsg) {
			var el = document.getElementById(rMsg.name);
			var pb = $("#" + rMsg.name);
			var newOpt;
			var lastOpt;
			var curPos;
			var doSel;

			if (el == null) {
				return true;
			}

			switch (rMsg.dwid) {
				case 1:
					if ('selectionStart' in el) {
						if ($("#" + rMsg.name).is(":focus")) {
							el.selectionStart = 0;
							el.selectionEnd = el.value.length;
						}
					}
					break;
				case 2:
					if ('selectionStart' in el) {
						if (rMsg.ss != undefined) {
							el.selectionStart = rMsg.ss;
						}
						if (rMsg.se != undefined) {
							el.selectionEnd = rMsg.se;
						}
					}
					break;
				case 3:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;

					if ('selectionStart' in el) {
						myResult.ss = el.selectionStart;
						myResult.se = el.selectionEnd;

						if (rMsg.pos == 0) {
							myResult.str = el.value;
						}
						else if (el.selectionStart != el.selectionEnd) {
							myResult.sel = el.value.substring(el.selectionStart, el.selectionEnd);
						}
					}

					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
					break;

				case 4:
					if (rMsg.pos == 0) {
						el.value = rMsg.str;
					}
					else {
						if ('selectionStart' in el) {
							// check whether some text is selected 
							if (el.selectionStart != el.selectionEnd) {
								var newText = el.value.substring(0, el.selectionStart) +
                                             rMsg.str + el.value.substring(el.selectionEnd);
								el.value = newText;
							}
						}
					}
					break;
				case 5:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;
					myResult.val = 0;

					switch (rMsg.typ) {
						case 0: myResult.val = el.value.length; break;
						case 1: if ('selectionStart' in el) {
								myResult.val = el.selectionStart;
							}
							break;
						case 2: if ('selectionEnd' in el) {
								myResult.val = el.selectionEnd;
							}
							break;
						default: myResult.val = 0; break;
					}
					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
					break;

				case 6:
					if (rMsg.pos == 0) {
						el.value += rMsg.str;
					}
					else {
						if ('selectionStart' in el) {
							var newText = el.value.substring(0, el.selectionEnd) +
                                             rMsg.str + el.value.substring(el.selectionEnd);
							el.value = newText;
						}
					}
					break;

				case 7:
					if (rMsg.ae != undefined) {
						el.plbdata.ae = (rMsg.ae == 0) ? false : true;
					}
					if (rMsg.ot != undefined) {
						el.plbdata.ot = (rMsg.ot == 0) ? false : true;
					}
					if (rMsg.sa != undefined) {
						el.plbdata.sa = (rMsg.sa == 0) ? false : true;
					}
					if (rMsg.dpi != undefined) {
						el.plbdata.dpi = (rMsg.dpi == 0) ? false : true;
					}
					if (rMsg.am != undefined) {
						el.plbdata.am = (rMsg.am == 0) ? false : true;
					}
					if (rMsg.dd != undefined) {
						el.plbdata.dd = rMsg.dd;
						EditNumPutString(el, "0", false);
					}
					if (rMsg.fd != undefined) {
						el.plbdata.fd = rMsg.fd;
						EditNumPutString(el, "0", false);
					}

					if (rMsg.updn != undefined) {

						if ((el.plbdata.updn == 1) || (el.plbdata.updn == 3)) {
							if ((rMsg.updn != 1) && (rMsg.updn != 3)) {
								pb.spinner("destroy");
							}
						}
						else {
							if ((rMsg.updn == 1) || (rMsg.updn == 3)) {
								pb.spinner();
								pb.spinner("option", "min", el.plbdata.udmi);
								pb.spinner("option", "max", el.plbdata.udmx);
								pb.spinner("option", "step", el.plbdata.udic);
								PlbWebBasic.prototype.setupNumCe(rMsg.name);
							}
						}

						el.plbdata.updn = rMsg.updn;
					}

					if (rMsg.udmi != undefined) {
						el.plbdata.udmi = rMsg.udmi;
						if ((el.plbdata.updn == 1) || (el.plbdata.updn == 3)) {
							pb.spinner("option", "min", el.plbdata.udmi);
						}
					}
					if (rMsg.udmx != undefined) {
						el.plbdata.udmx = rMsg.udmx;
						if ((el.plbdata.updn == 1) || (el.plbdata.updn == 3)) {
							pb.spinner("option", "max", el.plbdata.udmx);
						}
					}

					if (rMsg.udic != undefined) {
						el.plbdata.udic = rMsg.udic;
						if ((el.plbdata.updn == 1) || (el.plbdata.updn == 3)) {
							pb.spinner("option", "step", el.plbdata.udic);
						}
					}
					break;

				case 8:
					if ((el.plbdata.updn == 1) || (el.plbdata.updn == 3)) {
						pb.spinner("enable");
					}
					el.disabled = false;
					break;

				case 9:
					if ((el.plbdata.updn == 1) || (el.plbdata.updn == 3)) {
						pb.spinner("disable");
					}
					el.disabled = true;
					break;
				case 20:
					if ((el.plbdata.updn == 1) || (el.plbdata.updn == 3)) {
						try { pb.spinner("option", JSON.parse(rMsg.opt)); }
						catch (exception) { }
					}
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.methTab = function (rMsg) {
			var pb = $("#" + rMsg.name);
			var li;

			if (pb[0] == null) {
				return true;
			}

			switch (rMsg.dwid) {
				case 1:
					pb.tabs("option", "active", rMsg.pos);
					break;
				case 2:
					pb.tabs("enable");
					break;
				case 3:
					pb.tabs("disable");
					break;
				case 4:
					pb.on("tabsactivate", function (event, ui) { PlbWebBasic.prototype.AddPlbTabEv(event, ui, rMsg.name, 3) });
					break;
				case 5:
					pb.on("tabsbeforeactivate", function (event, ui) { PlbWebBasic.prototype.AddPlbTabEv(event, ui, rMsg.name, 4) });
					break;
				case 6:
					li = "<li><a href='#" + rMsg.id + "-1'>" + rMsg.lab + "</a></li>";
					if (rMsg.pos > 999) {
						pb.find(".ui-tabs-nav").append(li);
					}
					else {
						pb.find(".ui-tabs-nav li:eq(" + rMsg.pos + ")").before(li);
					}
					pb.tabs("refresh");
					break;
				case 7:
					pb.find(".ui-tabs-nav li:eq(" + rMsg.pos + ")").remove();
					pb.tabs("refresh");
					break;
				case 8:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;
					myResult.val = pb.tabs("option", "active");
					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
				case 20:
					try { pb.tabs("option", JSON.parse(rMsg.opt)); }
					catch (exception) { }
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.methPan = function (rMsg) {
			var tabnew;
			var tabcur;
			var el = $("#" + rMsg.name);

			if (el[0] == null) {
				return true;
			}

			switch (rMsg.dwid) {
				case 1:
					try {
						el.html(rMsg.html);
						$("#" + rMsg.name + " [tabindex!=0]").each(function (index, element) { PlbWebBasic.prototype.setupFoc1(element); });
						if (rMsg.jqm != undefined) {
							$("#" + rMsg.name).enhanceWithin();
						}
					}
					catch (exception) { }
					break;

				case 2:
					try {
						el.html(rMsg.html);
						$("#" + rMsg.name + " [data-plbevent]").each(function () {
							$(this).on($(this).attr("data-plbevent"), { plbref: rMsg.name, et: 99977 }, PlbWebBasic.prototype.jqEvent);
						});
						if (rMsg.hctl != undefined) {
							$("#" + rMsg.name + " [data-plbtabid]").each(function () {
								$(this).on("focus", { plbref: rMsg.name, plbtab: $(this).attr("data-plbtabid"), et: 99971 }, PlbWebBasic.prototype.jqEvent);
							});
						}
						else {
							$("#" + rMsg.name + " [tabindex!=0]").each(function (index, element) { PlbWebBasic.prototype.setupFoc1(element); });
						}
						if (rMsg.jqm != undefined) {
							$("#" + rMsg.name).enhanceWithin();
						}
					}
					catch (exception) { }
					break;

				case 3:
					try {
						$("#" + rMsg.name + " [data-plbevent]").each(function () {
							$(this).off($(this).attr("data-plbevent"), PlbWebBasic.prototype.jqEvent);
						});
						$("#" + rMsg.name + " [data-plbtabid]").each(function () {
							$(this).off($(this).attr("data-plbevent"), PlbWebBasic.prototype.jqEvent);
						});
						$("#" + rMsg.name + " [data-plbevent]").each(function () {
							$(this).on($(this).attr("data-plbevent"), { plbref: rMsg.name, et: 99977 }, PlbWebBasic.prototype.jqEvent);
						});
						$("#" + rMsg.name + " [data-plbtabid]").each(function () {
							$(this).on("focus", { plbref: rMsg.name, plbtab: $(this).attr("data-plbtabid"), et: 99971 }, PlbWebBasic.prototype.jqEvent);
						});
					}
					catch (exception) { }
					break;

				case 4: el.focus(); break;

				case 5: try {
						$("#" + rMsg.name + " [data-plbenable]").each(function () {
							$(this).attr('disabled', 'disabled');
						});
					}
					catch (exception) { }
					break

				case 6: try {
						$("#" + rMsg.name + " [data-plbenable]").each(function () {
							$(this).removeAttr('disabled');
						});
					}
					catch (exception) { }
					break;

				case 7:
					try {
						el.on("focusin", { plbref: rMsg.name, et: 99972 }, PlbWebBasic.prototype.jqEvent);
					}
					catch (exception) { }
					break;

				case 8: try {
						el = null;

						if (rMsg.fwd != undefined) {
							tabcur = 32767;
							$("#" + rMsg.name + " [data-plbtabid]").each(function () {
								tabnew = parseInt($(this).attr("data-plbtabid"));
								if ((tabnew > 0) && (tabnew > rMsg.tid) && (tabnew < tabcur)) {
									tabcur = tabnew;
									el = $(this);
								}
							});
						}
						else {
							tabcur = 0;
							$("#" + rMsg.name + " [data-plbtabid]").each(function () {
								tabnew = parseInt($(this).attr("data-plbtabid"));
								if ((tabnew > 0) && (tabnew < rMsg.tid) && (tabnew > tabcur)) {
									tabcur = tabnew;
									el = $(this);
								}
							});
						}

						if (el != null) {
							el.focus();
							PlbWebBasic.prototype.sendMsg({ action: 2, result: 1, tabid: tabcur });
							return false;
						}
					}
					catch (exception) { }
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.lvSetTableRtns = function (rMsg) {
			$("#" + rMsg.name + " div table tr td").bind("dblclick", function (evt) {
				var em = 0;
				if (evt.altKey) {
					em = 1;
				}
				if (evt.ctrlKey) {
					em += 2;
				}
				if (evt.shiftKey) {
					em += 4;
				}
				if (evt.button == 1) {
					em += 8;
				}
				if (evt.button == 2) {
					em += 16;
				}
				$("#" + rMsg.name).focus();
				PlbWebBasic.prototype.makeEvent(8, 99990, 0x20, em, 1, $(this).attr('id'), 0);
			});

			$("#" + rMsg.name + " div table tr td").bind("click", function (evt) {
				var par;
				var em = 0;
				if (evt.altKey) {
					em = 1;
				}
				if (evt.ctrlKey) {
					em += 2;
				}
				if (evt.shiftKey) {
					em += 4;
				}
				if (evt.button == 1) {
					em += 8;
				}
				if (evt.button == 2) {
					em += 16;
				}
				if (osA && ($("#" + rMsg.name + " table tbody").hasClass('ui-selectable-disabled') == false)) {
					par = $(this).parent();

					if (rMsg.ms == undefined) {
						$("#" + rMsg.name + " table tr").removeClass('ui-selected');
						$("#" + rMsg.name + " table tr").removeClass('ui-selectednf');
						par.addClass('ui-selected');
					}
					else {
						if (par.hasClass('ui-selected') == false) {
							par.addClass('ui-selected');
						}
						else {
							par.removeClass('ui-selected');
						}
					}
				}
				if ($(this).children(":first").is("input")) { $(this).children(":first").focus(); }
				else { $("#" + rMsg.name).focus(); }
				PlbWebBasic.prototype.makeEvent(8, 99990, 0x20, em, 0, $(this).attr('id'), 0);
			});

			$("#" + rMsg.name + " div table tr td input[type='checkbox']").bind("click", function (evt) {
				var ev = 0;
				if ($(this).prop('checked')) {
					ev = 1;
				}
				$("#" + rMsg.name).focus();
				PlbWebBasic.prototype.makeEvent(8, 99989, 0x20, 0, ev, $(this).attr('id'), 0);
			});
			
			if( rMsg.dt ) {
				$("#" + rMsg.name + " div table tbody tr td input[type!='checkbox']").change(function () {
					PlbWebBasic.prototype.makeEvent(8, 99970, 0x20, 0, 0, $(this).parent().attr('id'), 0, $(this).val());
				});
				
				$("#" + rMsg.name + " div table tbody tr td input[type='button']").click(function () {
					PlbWebBasic.prototype.makeEvent(8, 99970, 0x20, 0, 0, $(this).parent().attr('id'), 0, 1 );
				});
				$("#" + rMsg.name + " div table tbody tr td input[type='image']").click(function () {
					PlbWebBasic.prototype.makeEvent(8, 99970, 0x20, 0, 0, $(this).parent().attr('id'), 0, 1 );
				});
				$("#" + rMsg.name + " div table tr td input[type!='checkbox']").bind("focus", function (evt) {
					var el = $("#" + rMsg.name);

					if (el[0] != null) {
						el[0].plbdata.nf = 0;
						el[0].plbdata.hf = 1;
					}
				});
				
				$("#" + rMsg.name + " div table tfoot tr td ul li").bind("click", function (evt) {
					PlbWebBasic.prototype.makeEvent(8, 99966, 0x20, 0, 0, $(this).attr('id'), 0);
				});
			}
			else {
				$("#" + rMsg.name + " div table tr td input[type='text']").change(function () {
					PlbWebBasic.prototype.makeEvent(8, 99970, 0x20, 0, 0, $(this).parent().attr('id'), 0, $(this).val());
				});

				$("#" + rMsg.name + " div table tr td input[type='text']").bind("focus", function (evt) {
					var el = $("#" + rMsg.name);

					if (el[0] != null) {
						el[0].plbdata.nf = 0;
						el[0].plbdata.hf = 1;
					}
				});
			}
			
			$("#" + rMsg.name + " div table tr td input[data-plbe='n' ]").bind("keypress", function (evt) {
				if ((((evt.charCode < 48) || (evt.charCode > 57)) && (evt.charCode >= 32))) {
					evt.preventDefault();     // Prevent character input
					return;
				}
			});

			if( rMsg.dt ) {
				$("#" + rMsg.name + " div table tr td input").bind("keydown", function (evt) {
					var par, newfoc, selName;
					var el = $("#" + rMsg.name);

					evt = (evt) ? evt : ((event) ? event : null);

					if (evt.keyCode != 9) {
						return;
					}

					if (evt.shiftKey) {
						par = $(this).parent().prev();
						while (par != null && par.length == 1) {
							newfoc = par.find("input");
							if (newfoc != null && newfoc.length == 1)
								break;
							par = par.prev();
						}
					}
					else {
						par = $(this).parent().next();
						while (par != null && par.length == 1) {
							newfoc = par.find("input");
							if (newfoc != null && newfoc.length == 1)
								break;
							par = par.next();
						}
					}

					if (par != null && newfoc != null && newfoc.length == 1) {
						newfoc.focus();
						evt.preventDefault();
						evt.stopPropagation();
						return;
					}
					else {
						el[0].plbdata.nf = 1;
						selName = "#" + rMsg.name + " div table tr.ui-selected";
						$(selName).addClass("ui-selectednf");
						$(selName).removeClass("ui-selected");
					}
				});
			}

			$("#" + rMsg.name + " table tbody tr").dblclick(function () {
				if ($("#" + rMsg.name + " table tbody").hasClass('ui-selectable') == false) {
					return;
				}
				if ($(this).hasClass('plblvh') == false) {
					if (rMsg.ms == undefined) {
						$("#" + rMsg.name + " table tr").removeClass('ui-selected');
						$("#" + rMsg.name + " table tr").removeClass('ui-selectednf');
					}
					$(this).addClass('ui-selected');
				}
			});

			$("#" + rMsg.name + " table tbody tr").click(function () {
				if ($("#" + rMsg.name + " table tbody").hasClass('ui-selectable') == false) {
					return;
				}
				if ($(this).hasClass('plblvh') == false) {
					if (rMsg.ms == undefined) {
						$("#" + rMsg.name + " table tr").removeClass('ui-selected');
						$("#" + rMsg.name + " table tr").removeClass('ui-selectednf');
						$(this).addClass('ui-selected');
					}
					else {
						if ($(this).hasClass('ui-selected') == false) {
							$(this).addClass('ui-selected');
						}
						else {
							$(this).removeClass('ui-selected');
						}
					}
				}
			});
		}

		PlbWebBasic.prototype.methLv = function (rMsg) {
			var el = $("#" + rMsg.name);
			var el1;
			var tb, cell, selName, selCss, selFoc;
			var arr, arrc, arrt, arrb, arrck, ckid;
			var rows, rlen, i, j, cells, clen, row;

			if (el[0] == null) {
				return true;
			}

			if (el[0].plbdata == undefined) {
				el[0].plbdata = new Object();
				el[0].plbdata.nf = el.is(":focus") ? 0 : 1;
			}

			if (el[0].plbdata.nf == 1) {
				selCss = "ui-selectednf";
				selFoc = "ui-focusednf";
			}
			else {
				selCss = "ui-selected";
				selFoc = "ui-focused";
			}

			switch (rMsg.dwid) {
				case 1:
					el[0].plbdata.nf = el.is(":focus") ? 0 : 1;
					el.html(rMsg.html);

					el1 = $("#" + rMsg.name + " div table tr.ui-focused");

					if (el1[0] != null) {
						el[0].plbdata.hf = 1;
						if (el[0].plbdata.nf == 1) {
							el1.addClass("ui-focusednf");
							el1.removeClass("ui-focused");
						}
					}

					if (el[0].plbdata.nf == 1) {
						selName = "#" + rMsg.name + " div table tr.ui-selected";
						$(selName).addClass("ui-selectednf");
						$(selName).removeClass("ui-selected");
					}

					$("#" + rMsg.name + " div table tr th").bind("click", function () {
						PlbWebBasic.prototype.makeEvent(8, 99991, 0x20, 0, 0, $(this).attr('id'), 0);
					});

					if (!osA) {
						$("#" + rMsg.name + " table tbody").selectable({
							distance: 100,
							filter: "tr",
							disabled: true
						});
					}
					PlbWebBasic.prototype.lvSetTableRtns(rMsg);

					if (el[0].plbdata.esu != undefined) {
						break;
					}

					el[0].plbdata.esu = 1;

					el.bind("blur", function (evt) {
						if ((el[0].plbdata.skf != undefined) && (el[0].plbdata.skf == 1)) {
							el[0].plbdata.skf = 0;
							return;
						}
						if (!osA && ($("#" + rMsg.name + " table tbody").hasClass('ui-selectable') == false)) {
							return;
						}
						if (osA && $("#" + rMsg.name + " table tbody").hasClass('ui-selectable-disabled')) {
							return;
						}

						selName = "#" + rMsg.name + " div table tr.ui-selected";
						$(selName).addClass("ui-selectednf");
						$(selName).removeClass("ui-selected");
						el[0].plbdata.nf = 1;

						if (el[0].plbdata.hf != undefined) {
							selName = "#" + rMsg.name + " div table tr.ui-focused";
							$(selName).addClass("ui-focusednf");
							$(selName).removeClass("ui-focused");
						}
					});

					el.bind("focus", function (evt) {

						if (!osA && ($("#" + rMsg.name + " table tbody").hasClass('ui-selectable') == false)) {
							return;
						}
						if (osA && $("#" + rMsg.name + " table tbody").hasClass('ui-selectable-disabled')) {
							return;
						}

						if (rMsg.dt) {
							var newfoc = $("#" + rMsg.name + " div table tr.ui-selectednf td input");
							if (newfoc != null && newfoc.length > 0) {
								el[0].plbdata.skf = 1;
								newfoc[0].focus();
							}

						}

						selName = "#" + rMsg.name + " div table tr.ui-selectednf";
						$(selName).addClass("ui-selected");
						$(selName).removeClass("ui-selectednf");
						el[0].plbdata.nf = 0;

						if (el[0].plbdata.hf != undefined) {
							selName = "#" + rMsg.name + " div table tr.ui-focusednf";
							$(selName).addClass("ui-focused");
							$(selName).removeClass("ui-focusednf");
						}
					});

					el.bind("keydown", function (evt) {
						if ($("#" + rMsg.name + " table tbody").hasClass('ui-selectable') == false) {
							return;
						}

						var charCode = (evt.which) ? evt.which : event.keyCode;
						if ((charCode == '35') || (charCode == '36') || (charCode == '38') || (charCode == '40')) {
							$("#" + rMsg.name).focus();
							PlbWebBasic.prototype.makeEvent(8, 99983, charCode, 0, 0, rMsg.name, 0);
						}
					});
					el.bind("keypress", function (evt) {
						if ($("#" + rMsg.name + " table tbody").hasClass('ui-selectable') == false) {
							return;
						}

						if (evt.charCode == 0x20) {
							PlbWebBasic.prototype.makeEvent(8, 99983, evt.charCode, 0, 0, rMsg.name, 0);
						}
					});
					break;

				case 2:
					tb = document.getElementById(rMsg.name + "b");
					if (tb != null) {
						rows = tb.rows;
						rlen = rows.length;
						if (rMsg.srt.length == rows.length) {
							arr = new Array();
							arrc = new Array();
							arrt = new Array();
							arrb = new Array();
							for (i = 0; i < rlen; i++) {
								cells = rows[rMsg.srt[i]].cells;
								clen = cells.length;
								arr[i] = new Array();
								arrc[i] = new Array();
								arrt[i] = new Array();
								arrb[i] = new Array();
								for (j = 0; j < clen; j++) {
									arr[i][j] = cells[j].innerHTML;
									arrc[i][j] = cells[j].style.color;
									arrt[i][j] = cells[j].style.textAlign;
									arrb[i][j] = cells[j].style.backgroundColor;
								}
							}

							for (i = 0; i < rlen; i++) {
								clen = arr[i].length;
								row = "";
								for (j = 0; j < clen; j++) {
									cell = "<td id='" + rMsg.name + "R" + i + "I" + j + "'>" + arr[i][j] + "</td>";
									row += cell;
								}
								arr[i] = row;
							}

							tb.innerHTML = "<tr>" + arr.join("</tr><tr>") + "</tr>";

							rows = tb.rows;
							rlen = rows.length;
							for (i = 0; i < rlen; i++) {
								cells = rows[i].cells;
								clen = cells.length;
								for (j = 0; j < clen; j++) {
									cells[j].style.color = arrc[i][j];
									cells[j].style.textAlign = arrt[i][j];
									cells[j].style.backgroundColor = arrb[i][j];
								}
							}
							if (rMsg.ck != undefined) {
								arrck = new Array();
								for (i = 0; i < rlen; i++) {
									ckid = document.getElementById(rMsg.name + "C" + rMsg.srt[i]);
									arrck[i] = ckid;
								}

								for (i = 0; i < rlen; i++) {
									ckid = arrck[i];
									if (ckid != null) {
										ckid.id = rMsg.name + "C" + i;
									}
								}

								rlen = rMsg.ck.length;
								for (i = 0; i < rlen; i++) {
									ckid = document.getElementById(rMsg.name + "C" + rMsg.ck[i]);
									if (ckid != null) {
										ckid.checked = true;
									}
								}
							}
							PlbWebBasic.prototype.lvSetTableRtns(rMsg);
						}
					}
					break;

				case 3:
					$("#" + rMsg.name + " div table tr." + selCss).removeClass(selCss);
					if (rMsg.rn >= 0) {
						row = "#" + rMsg.name + "R" + rMsg.rn + "I" + rMsg.pos;
						$(row).parent().addClass(selCss);
						try {
							$(row).parent()[0].scrollIntoView(false);
						}
						catch (exception) { }
						if (rMsg.df != undefined) {
							$("#" + rMsg.name).focus();
							row = "#" + rMsg.name + "R" + rMsg.rn + "I" + rMsg.df;
							if ($(row).children(":first").is("input")) {
								el[0].plbdata.skf = 1;
								$(row).children(":first").focus();
							}
						}
					}
					break;
				case 4:
					row = "#" + rMsg.name + "R" + rMsg.rn + "I" + rMsg.pos;
					try {
						$(row).parent()[0].scrollIntoView(false);
					}
					catch (exception) { }
					break;
				case 5:
					tb = document.getElementById(rMsg.name + "b");
					if (tb != null) {
						$(tb).addClass("ui-selectable-disabled");
						$(tb).removeClass("ui-selectable");
						if (rMsg.dl == undefined) {
							rows = tb.rows;
							rlen = rows.length;
							for (i = 0; i < rlen; i++) {
								ckid = document.getElementById(rMsg.name + "C" + i);
								if (ckid != null) {
									ckid.disabled = true;
								}
							}
						}
					}
					break;
				case 6:
					tb = document.getElementById(rMsg.name + "b");
					if (tb != null) {
						if (!osA) {
							$(tb).addClass("ui-selectable");
						}
						$(tb).removeClass("ui-selectable-disabled");
						if (rMsg.dl == undefined) {
							rows = tb.rows;
							rlen = rows.length;
							for (i = 0; i < rlen; i++) {
								ckid = document.getElementById(rMsg.name + "C" + i);
								if (ckid != null) {
									ckid.disabled = false;
								}
							}
						}
					}
					break;
				case 7:
					while (rMsg.start <= rMsg.end) {
						row = "#" + rMsg.name + "R" + rMsg.start + "I" + rMsg.pos;
						if (rMsg.sel == undefined) {
							$(row).parent().removeClass(selCss);
						}
						else {
							$(row).parent().addClass(selCss);
						}
						rMsg.start++;
					}
					break;
				case 8:
					el[0].plbdata.hf = 1;
					$("#" + rMsg.name + " div table tr." + selFoc).removeClass(selFoc);
					if (rMsg.rn >= 0) {
						row = "#" + rMsg.name + "R" + rMsg.rn + "I" + rMsg.pos;
						$(row).parent().addClass(selFoc);
						try {
							$(row).parent()[0].scrollIntoView(false);
						}
						catch (exception) { }
					}
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.tvSetTableRtns = function (rMsg) {
			$("#" + rMsg.name + " li").bind("dblclick", function (evt) {
				var em = 0;
				if (evt.altKey) {
					em = 1;
				}
				if (evt.ctrlKey) {
					em += 2;
				}
				if (evt.shiftKey) {
					em += 4;
				}
				if (evt.button == 1) {
					em += 8;
				}
				if (evt.button == 2) {
					em += 16;
				}

				$("#" + rMsg.name).focus();
				PlbWebBasic.prototype.makeEvent(8, 99980, 0x20, em, 1, $(this).attr('id'), 0);
				evt.stopPropagation();
			});

			$("#" + rMsg.name + " span").bind("click", function (evt) {
				var par;
				var em = 0;
				if (evt.altKey) {
					em = 1;
				}
				if (evt.ctrlKey) {
					em += 2;
				}
				if (evt.shiftKey) {
					em += 4;
				}
				if (evt.button == 1) {
					em += 8;
				}
				if (evt.button == 2) {
					em += 16;
				}

				$("#" + rMsg.name).focus();
				PlbWebBasic.prototype.makeEvent(8, 99980, 0x20, em, 0, $(this).parent().attr('id'), 0);
				evt.stopPropagation();
			});

			$("#" + rMsg.name + " p").bind("click", function (evt) {
				$("#" + rMsg.name).focus();
				PlbWebBasic.prototype.makeEvent(8, 99979, 0x20, 0, 3, $(this).parent().attr('id'), 0);
				evt.stopPropagation();
			});

			$("#" + rMsg.name + " detail").bind("click", function (evt) {
				$("#" + rMsg.name).focus();
				PlbWebBasic.prototype.makeEvent(8, 99979, 0x20, 0, 3, $(this).parent().attr('id'), 0);
				evt.stopPropagation();
			});

			$("#" + rMsg.name + " input").bind("click", function (evt) {
				var ev = 0;
				if ($(this).prop('checked')) {
					ev = 1;
				}
				$("#" + rMsg.name).focus();
				PlbWebBasic.prototype.makeEvent(8, 99979, 0x20, 0, ev, $(this).parent().attr('id'), 0);
				evt.stopPropagation();
			});
		}

		PlbWebBasic.prototype.methTv = function (rMsg) {
			var el = $("#" + rMsg.name);
			var item, selCss;

			if (el[0] == null) {
				return true;
			}

			if (el[0].plbdata == undefined) {
				el[0].plbdata = new Object();
				el[0].plbdata.nf = el.is(":focus") ? 0 : 1;
			}

			if (el[0].plbdata.nf == 1) {
				selCss = "ui-selectednf";
			}
			else {
				selCss = "ui-selected";
			}

			switch (rMsg.dwid) {
				case 1:
					el.html(rMsg.html);

					if (el[0].plbdata.nf == 1) {
						selName = "#" + rMsg.name + " span.ui-selected";
						$(selName).addClass("ui-selectednf");
						$(selName).removeClass("ui-selected");
					}

					PlbWebBasic.prototype.tvSetTableRtns(rMsg);

					$("#" + rMsg.name + " p.treevm").addClass("ui-icon");
					$("#" + rMsg.name + " p.treevp").addClass("ui-icon");

					if (rMsg.isrc != undefined) {
						$("#" + rMsg.name + " .plbtvi").width(rMsg.iw + "px");
						$("#" + rMsg.name + " .plbtvi").height(rMsg.ih + "px");
						$("#" + rMsg.name + " .plbtvi").css('backgroundImage', "url('" + rMsg.isrc + "')");
					}

					if (el[0].plbdata.esu != undefined) {
						break;
					}

					el[0].plbdata.esu = 1;

					el.bind("blur", function (evt) {
						selName = "#" + rMsg.name + " span.ui-selected";
						$(selName).addClass("ui-selectednf");
						$(selName).removeClass("ui-selected");
						el[0].plbdata.nf = 1;
					});

					el.bind("focus", function (evt) {
						selName = "#" + rMsg.name + " span.ui-selectednf";
						$(selName).addClass("ui-selected");
						$(selName).removeClass("ui-selectednf");
						el[0].plbdata.nf = 0;
					});

					el.bind("keydown", function (evt) {
						var charCode = (evt.which) ? evt.which : event.keyCode;
						if ((charCode == '35') || (charCode == '36') || (charCode == '37') || (charCode == '38') || (charCode == '39') || (charCode == '40')) {
							PlbWebBasic.prototype.makeEvent(8, 99978, charCode, 0, 0, rMsg.name, 0);
						}
					});
					el.bind("keypress", function (evt) {
						PlbWebBasic.prototype.makeEvent(8, 99978, evt.charCode, 0, 0, rMsg.name, 0);
					});
					break;

				case 2:
					item = $("#" + rMsg.name + "R" + rMsg.rn);
					if (item[0] != null) {
						if (rMsg.exp != undefined) {
							item.removeClass('plbtvc');
							$("#" + rMsg.name + "R" + rMsg.rn + ">p").removeClass("treevp");
							$("#" + rMsg.name + "R" + rMsg.rn + ">p").addClass("treevm");
						}
						else {
							item.addClass('plbtvc');
							$("#" + rMsg.name + "R" + rMsg.rn + ">p").removeClass("treevm");
							$("#" + rMsg.name + "R" + rMsg.rn + ">p").addClass("treevp");
						}
					}
					break;
				case 3:
					try {
						$("#" + rMsg.name + " span." + selCss).removeClass(selCss);
						if (rMsg.rn >= 0) {
							$("#" + rMsg.name + "R" + rMsg.rn + ">span").addClass(selCss);
							if (rMsg.io != undefined) {
								$("#" + rMsg.name + "R" + rMsg.rn + ">.plbtvi").css("background-position", "-" + rMsg.io + "px 0px");
							}
							if (rMsg.ls != undefined) {
								$("#" + rMsg.name + "R" + rMsg.ls + ">.plbtvi").css("background-position", "-" + rMsg.lo + "px 0px");
							}
						}
					}
					catch (exception) { }
					break;
				case 4:
					item = $("#" + rMsg.name + "R" + rMsg.rn + ">input");
					if (item[0] != null) {
						item.prop('checked', rMsg.chk == undefined ? false : true);
					}
					break;
				case 5:
					item = $("#" + rMsg.name + "R" + rMsg.rn);
					try {
						$(row)[0].scrollIntoView(true);
					}
					catch (exception) { }
					break;
				case 6:
					if (rMsg.rn >= 0) {
						row = "#" + rMsg.name + "R" + rMsg.rn + ">span";
						$(row).html(rMsg.tx);
					}
					break;
				case 7:
					try {
						$("#" + rMsg.name + "R" + rMsg.rn + ">.plbtvi").css("background-position", "-" + rMsg.io + "px 0px");
					}
					catch (exception) { }
					break;

				case 8:
					$("#" + rMsg.name + " input").prop('disabled', false);
					break;

				case 9:
					$("#" + rMsg.name + " input").prop('disabled', true);
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.methTb = function (rMsg) {
			var el = $("#" + rMsg.name);
			var items;

			if (el[0] == null) {
				return true;
			}

			switch (rMsg.dwid) {
				case 1:
					el.html(rMsg.html);
					$("#" + rMsg.name).tooltip();

					if (rMsg.bkt != undefined) {
						$("#" + rMsg.name + " .plbtbs1").selectmenu({
							classes: { "ui-selectmenu-button": "plbbkt plbtbs1 tb-sb-sel" }
						});
						$("#" + rMsg.name + " .plbtbs1d").selectmenu({
							disabled: true,
							classes: { "ui-selectmenu-button": "plbbkt plbtbs1 tb-sb-sel" }
						});
					}
					else {
						$("#" + rMsg.name + " .plbtbs1").selectmenu({
							classes: { "ui-selectmenu-button": "plbtbs1 tb-sb-sel" }
						});
						$("#" + rMsg.name + " .plbtbs1d").selectmenu({
							disabled: true,
							classes: { "ui-selectmenu-button": "plbtbs1 tb-sb-sel" }
						});
					}
					$("#" + rMsg.name + " .tb-sb-sel").height(rMsg.bh - 2);

					if (rMsg.bkt != undefined) {
						$("#" + rMsg.name + " .plbtbs2").selectmenu({
							classes: { "ui-selectmenu-button": "plbbkt plbtbs2 tb-sb-sel2" }
						});

						$("#" + rMsg.name + " .plbtbs2d").selectmenu({
							disabled: true,
							classes: { "ui-selectmenu-button": "plbbkt plbtbs2 tb-sb-sel2" }
						});
					}
					else {
						$("#" + rMsg.name + " .plbtbs2").selectmenu({
							classes: { "ui-selectmenu-button": "plbtbs2 tb-sb-sel2" }
						});

						$("#" + rMsg.name + " .plbtbs2d").selectmenu({
							disabled: true,
							classes: { "ui-selectmenu-button": "plbtbs2 tb-sb-sel2" }
						});
					}

					items = $("#" + rMsg.name + " .tb-sb-sel2");

					items.each(function (idx, ele) {
						$(ele).height(rMsg.bh - 2);
						$(ele).width(rMsg.bw + 8);
						$(ele).append(rMsg.seli[idx]);
					});

					$("#" + rMsg.name + " .plbtbs3").button();
					$("#" + rMsg.name + " .plbtbs3d").button({ disabled: true });
					$("#" + rMsg.name + " .plbtbcr").checkboxradio({ icon: false });
					$("#" + rMsg.name + " .plbtbcrd").checkboxradio({ disabled: true, icon: false });
					$("#" + rMsg.name + " .plbtbcrc").prop('checked', true).checkboxradio('refresh');
					$("#" + rMsg.name + " .plbtbbe").bind("click", function (evt) {
						PlbWebBasic.prototype.makeEvent(8, 99973, 0x20, 0, 0, $(this).attr('id'), 0);
						evt.stopPropagation();
					});
					$("#" + rMsg.name + " .plbtbbe").bind("dblclick", function (evt) {
						PlbWebBasic.prototype.makeEvent(8, 99973, 0x20, 1, 0, $(this).attr('id'), 0);
						evt.stopPropagation();
					});
					$("#" + rMsg.name + " .plbtbse").bind("selectmenuchange", function (evt) {
						PlbWebBasic.prototype.makeEvent(8, 99973, 0x20, 0, $(this).val(), $(this).attr('id'), 0);
						evt.stopPropagation();
					});
					if (rMsg.isrc != undefined) {
						$("#" + rMsg.name + " .plbtbi").width(rMsg.iw + "px");
						$("#" + rMsg.name + " .plbtbi").height(rMsg.ih + "px");
						$("#" + rMsg.name + " .plbtbi").css('backgroundImage', "url('" + rMsg.isrc + "')");
					}
					$("#" + rMsg.name + " [tabIndex]").removeAttr("tabIndex");
					break;

				case 2:
					try { $("#" + rMsg.name).tooltip("destroy");}
					catch (exception) { }
					break;

				case 5:
					$("#" + rMsg.name + " .ui-checkboxradio-label.ui-checkboxradio-checked.plbbkt").removeClass("plbbkt");
					$("#" + rMsg.name + " .ui-checkboxradio-label.ui-checkboxradio-checked:not(.plbbkts)").addClass("plbbkts");
					$("#" + rMsg.name + " .ui-checkboxradio-label:not(.ui-checkboxradio-checked).plbbkts").removeClass("plbbkts");
					$("#" + rMsg.name + " .ui-checkboxradio-label:not(.ui-checkboxradio-checked):not(.plbbkt)").addClass("plbbkt");
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.plbDragItem = function (rMsg) {
			var pos1 = 0, pos2 = 0, pos3 = 0, pos4 = 0; pos5 = 0; pos6 = 0;
			var oldz;
			var el = document.getElementById(rMsg.name);

			el.style.cursor = rMsg.crn;

			if ((rMsg.vm == 0) && (rMsg.hm == 0)) {
				el.onmousedown = null;
				return;
			}

			el.onmousedown = dragMouseDown;

			function dragMouseDown(e) {
				e = e || window.event;
				e.preventDefault();
				pos3 = e.clientX;
				pos4 = e.clientY;
				pos5 = 0;
				pos6 = 0;
				oldz = el.style.zIndex;
				el.style.zIndex = 10000;
				document.onmouseup = closeDragElement;
				document.onmousemove = elementDrag;
			}

			function elementDrag(e) {
				e = e || window.event;
				e.preventDefault();
				pos1 = pos3 - e.clientX;
				pos2 = pos4 - e.clientY;
				pos3 = e.clientX;
				pos4 = e.clientY;
				pos5 -= pos1;
				pos6 -= pos2;
				if (rMsg.vm == 1)
					el.style.top = (el.offsetTop - pos2) + "px";
				if (rMsg.hm == 1)
					el.style.left = (el.offsetLeft - pos1) + "px";
			}

			function closeDragElement() {
				document.onmouseup = null;
				document.onmousemove = null;
				el.onmousedown = null;
				el.style.zIndex = oldz;
				PlbWebBasic.prototype.makeEvent(8, 99988, 0x20, Math.round(pos5), Math.round(pos6), rMsg.name, 0);
			}
		}

		PlbWebBasic.prototype.PlbMenuEvent = function (id, myEm, myVal) {
			var name;

			if (id == null) {
				name = 'end';
			}
			else {
				name = id;
			}

			PlbWebBasic.prototype.makeEvent(8, 99994, 0x20, myEm, myVal, name, 0);

		}

		PlbWebBasic.prototype.menuOpen = function (evt) {
			var myVal;

			if (curMenu != null) {
				curMenu.hide();
				curMenu = null;
				PlbWebBasic.prototype.PlbMenuEvent(null, 5, 0);
			}
			else {
				myVal = evt.currentTarget.offsetLeft;
				PlbWebBasic.prototype.PlbMenuEvent(evt.currentTarget.id, 1, myVal);
			}
		}

		PlbWebBasic.prototype.menuMove = function (evt) {
			var el, myVal;

			el = $("#" + evt.currentTarget.id);

			if (!el.hasClass("ui-state-disabled")) {
				el.addClass("ui-state-focus");
				el.removeClass("ui-state-default");

				if ((curForm != 0) && (curMenu != null)) {
					myVal = evt.currentTarget.id.lastIndexOf("F");
					if (myVal > 0) {
						myVal = parseInt(evt.currentTarget.id.slice(myVal + 1));
					}
					if (myVal == curForm) {
						curMenu.hide();
						curMenu = null;
						myVal = evt.currentTarget.offsetLeft;

						PlbWebBasic.prototype.PlbMenuEvent(evt.currentTarget.id, 2, myVal);
					}
				}
			}
		}

		PlbWebBasic.prototype.menuMoveOut = function (evt) {
			var el = $("#" + evt.currentTarget.id);
			if (!el.hasClass("ui-state-disabled")) {
				el.removeClass("ui-state-focus");
				el.addClass("ui-state-default");
			}
		}

		PlbWebBasic.prototype.methMenu = function (rMsg) {
			var menu;
			var el = $("#" + rMsg.name);
			var cont, navd, pos;

			if (el[0] == null) {
				return true;
			}

			switch (rMsg.dwid) {
				case 1:
					if (rMsg.mk != undefined) {
						menu = $("#" + rMsg.name).menu();
						menu.on("menuselect", function (event, ui) { PlbWebBasic.prototype.PlbMenuEvent(ui.item.attr('id'), 5, 0); });
						el.css("z-index", '1100000');
					}
					else {
						menu = $("#" + rMsg.name);
						menu.show();
					}

					if (rMsg.f) {
						curForm = rMsg.f;
					}
					else {
						curForm = 0;
					}
					curMenu = menu;

					el.css("top", rMsg.t + 'px');
					el.css("left", rMsg.l + 'px');
					$(document).one("click", function () {
						if (curMenu != null) {
							curMenu.hide();
							curMenu = null;
							PlbWebBasic.prototype.PlbMenuEvent(null, 5, 0);
						}
					});
					break;

				case 2:
					cont = $("#" + rMsg.name + "D");
					navd = $("#" + rMsg.name + "N");
					if ((cont[0] == null) || (navd[0] == null)) {
						return true;
					}

					navd.html(rMsg.html);

					if (parseInt(cont.css("top"), 10) != 24) {
						pos = el.height() + 24;
						el.css("height", pos + 'px');
						cont.css("top", '24px');
						navd.css("display", "block");
					}

					$("#" + rMsg.name + "N > ul.fmenui > li").on("click", function (evt) { PlbWebBasic.prototype.menuOpen(evt); });
					$("#" + rMsg.name + "N > ul.fmenui > li").on("mouseenter", function (evt) { PlbWebBasic.prototype.menuMove(evt); });
					$("#" + rMsg.name + "N > ul.fmenui > li").on("mouseleave", function (evt) { PlbWebBasic.prototype.menuMoveOut(evt); });
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.methPBar = function (rMsg) {
			var pb = $("#" + rMsg.name + "D");

			if (pb[0] == null) {
				return true;
			}

			switch (rMsg.dwid) {
				case 1:
					pb.progressbar("value", rMsg.pos);
					break;
				case 2:
					pb[0].plbdata.dp = rMsg.dp;
					break;
				case 20:
					try { pb.progressbar("option", JSON.parse(rMsg.opt)); }
					catch (exception) { }
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.methSld = function (rMsg) {
			var pb = $("#" + rMsg.name);

			if (pb[0] == null) {
				return true;
			}

			switch (rMsg.dwid) {
				case 1:
					pb.slider("option", "value", rMsg.pos);
					break;
				case 2:
					pb.slider("option", "min", rMsg.pos);
					break;
				case 3:
					pb.slider("option", "max", rMsg.pos);
					break;
				case 4:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;
					myResult.val = pb.slider("option", "value");
					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
					break;
				case 5:
					pb.slider("disable");
					break;
				case 6:
					pb.slider("enable");
					break;
				case 7:
					pb.on("slidestop", function (event, ui) { PlbWebBasic.prototype.AddPlbSldEv(rMsg) });
					break;
				case 8:
					pb.slider("option", "step", rMsg.pos);
					break;
				case 20:
					try { pb.slider("option", JSON.parse(rMsg.opt)); }
					catch (exception) { }
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.methCli = function (rMsg) {
			var resopen;
			switch (rMsg.dwid) {
				case 1:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;
					myResult.height = screen.height;
					myResult.width = screen.width;
					myResult.availHeight = screen.availHeight;
					myResult.availWidth = screen.availWidth;
					myResult.colorDepth = screen.colorDepth;
					myResult.pixelDepth = screen.pixelDepth;
					myResult.appCodeName = navigator.appCodeName;
					myResult.appName = navigator.appName;
					myResult.appVersion = navigator.appVersion;
					myResult.cookieEnabled = navigator.cookieEnabled;
					myResult.language = navigator.language;
					myResult.platform = navigator.platform;
					myResult.product = navigator.product;
					myResult.userAgent = navigator.userAgent;
					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
					break;
				case 2:
					window.print();
					break;
				case 3:
					try {
						resopen = window.open(rMsg.url, rMsg.name, rMsg.specs);
						if (resopen == undefined) {
							PlbWebBasic.prototype.sendMsg({ action: 2, error: 10 }); /*window.open result is NULL!*/
							return false;
						}
					}
					catch (exception) {
						PlbWebBasic.prototype.sendMsg({ action: 2, error: 11, exception: JSON.stringify(exception) }); /*Exception encountered!*/
						return false;
					}
					break;
				case 4:
					$('head').append('<link rel="stylesheet" href="' + rMsg.url + '" type="text/css" />');
					break;
				case 5:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;
					if (navigator.geolocation) {
						navigator.geolocation.getCurrentPosition(
                                function (position) {
                                	if (getlocTimer) {
                                		window.clearTimeout(genTimer);
                                		getlocTimer = false; myResult.msg = position.coords.latitude + "," + position.coords.longitude; PlbWebBasic.prototype.sendMsg(myResult);
                                	}
                                },
                                function (error) {
                                	if (getlocTimer) {
                                		window.clearTimeout(genTimer);
                                		getlocTimer = false; myResult.msg = "E: " + error.code; PlbWebBasic.prototype.sendMsg(myResult);
                                	}
                                },
                                { timeout: 6000 });
					} else {
						myResult.msg = "E: 0"; PlbWebBasic.prototype.sendMsg(myResult);
					}
					if (!getlocTimer) {
						getlocTimer = true;
						genTimer = window.setTimeout(function () {
							if (getlocTimer) {
								getlocTimer = false; myResult.msg = "E: 3"; PlbWebBasic.prototype.sendMsg(myResult);
							}
						}, 8000);
					}
					return false;
					break;
				case 6:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;
					myResult.innerWidth = Math.round(window.innerWidth);
					myResult.innerHeight = Math.round(window.innerHeight);
					myResult.outerWidth = Math.round(window.outerWidth);
					myResult.outerHeight = Math.round(window.outerHeight);
					myResult.pageXOffset = Math.round(window.pageXOffset);
					myResult.pageYOffset = Math.round(window.pageYOffset);
					myResult.screenX = Math.round(window.screenX);
					myResult.screenY = Math.round(window.screenY);
					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
					break;

				case 7:
					try {
						$.ajax({
							url: '/userjs/' + rMsg.url,
							success: function (data) {
								eval(data);
							}
						})
					}
					catch (err) { }
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.methDt = function (rMsg) {
			var myTime;
			var el = document.getElementById(rMsg.name);
			var pb = $("#" + rMsg.name);

			if (pb[0] == null) {
				return true;
			}

			if ((el.plbdata != undefined) && el.plbdata.isTime) {
				switch (rMsg.dwid) {
					case 1:
						break;
					case 2:
						break;
					case 3:
						myResult = new Object();
						myResult.action = 2;
						myResult.result = 0;
						switch (rMsg.vid) {
							case 1: myResult.str = "00000000000000"; break;
							case 2: myResult.str = "00000000000000"; break;
							default:
								myTime = new Date(pb.timespinner("value"));
								myResult.str = "00000000";
								if (myTime.getHours() < 10) {
									myResult.str += "0" + myTime.getHours();
								}
								else {
									myResult.str += myTime.getHours();
								}
								if (myTime.getMinutes() < 10) {
									myResult.str += "0" + myTime.getMinutes();
								}
								else {
									myResult.str += myTime.getMinutes();
								}
								if (myTime.getSeconds() < 10) {
									myResult.str += "0" + myTime.getSeconds();
								}
								else {
									myResult.str += myTime.getSeconds();
								}
								break;
						}
						PlbWebBasic.prototype.sendMsg(myResult);
						return false;
						break;

					case 4:
						try {
							myTime = new Date();
							if (rMsg.dt != undefined) {
								myTime.setHours(Number(rMsg.dt.substr(8, 2)));
								myTime.setMinutes(Number(rMsg.dt.substr(10, 2)));
								myTime.setSeconds(Number(rMsg.dt.substr(12, 2)));
							}

							pb.timespinner("value", myTime);
						}
						catch (exception) { }
						break;

					case 5:
						break;

					case 20:
						try { pb.timespinner("option", JSON.parse(rMsg.opt)); }
						catch (exception) { }
						break;
				}
			}
			else {
				switch (rMsg.dwid) {
					case 1:
						try {
							pb.datepicker("option", "minDate", $.datepicker.parseDate("yymmdd", rMsg.dt));
						}
						catch (exception) { }
						break;
					case 2:
						try {
							pb.datepicker("option", "maxDate", $.datepicker.parseDate("yymmdd", rMsg.dt));
						}
						catch (exception) { }
						break;

					case 3:
						myResult = new Object();
						myResult.action = 2;
						myResult.result = 0;
						switch (rMsg.vid) {
							case 1: myResult.str = $.datepicker.formatDate("yymmdd000000", pb.datepicker("option", "minDate")); break;
							case 2: myResult.str = $.datepicker.formatDate("yymmdd000000", pb.datepicker("option", "maxDate")); break;
							default: if (el.plbdata.curDate != undefined) {
									myResult.str = $.datepicker.formatDate("yymmdd000000", el.plbdata.curDate);
								}
								else {
									myResult.str = $.datepicker.formatDate("yymmdd000000", pb.datepicker("getDate"));
								}
								break;
						}
						PlbWebBasic.prototype.sendMsg(myResult);
						return false;
						break;

					case 4:
						try {
							if (rMsg.dt == undefined) {
								pb.datepicker("setDate", new Date());
							}
							else {
								pb.datepicker("setDate", $.datepicker.parseDate("yymmdd", rMsg.dt));
			            	}
				            pb[0].curDt = $.datepicker.formatDate(pb.datepicker("option", "dateFormat"), pb.datepicker("getDate"));
						}
						catch (exception) { }
						break;

					case 5:
						el.plbdata.getdt = false;
						switch (rMsg.fmt) {
							case 0: break;
							case 1: pb.datepicker("option", "dateFormat", "DD, MM d, yy"); break;
							case 2: pb.datepicker("option", "dateFormat", "mm/dd/y"); break;
							case 3: break;
							case 4:
								if (rMsg.format != undefined) {
									pb.datepicker("option", "dateFormat", rMsg.format);
									el.plbdata.getdt = true;
									el.plbdata.format = rMsg.format;
								}
								break;
						}
						break;
					case 6:
						pb[0].curDt = $.datepicker.formatDate(pb.datepicker("option", "dateFormat"), pb.datepicker("getDate"));
						if (el.plbdata.resetz) {
							pb.datepicker('option', { onClose: function (dt) {
								var zorder = parseInt(pb.css("z-index"));
								if (zorder >= 1000000) {
									zorder -= 1000000
								};
								if (el.plbdata.getdt) {
									var m = $("#ui-datepicker-div .ui-datepicker-month :selected").val();
									var y = $("#ui-datepicker-div .ui-datepicker-year :selected").val();
									try {
										el.plbdata.curDate = $.datepicker.parseDate(el.plbdata.format, dt);
									}
									catch (exception) {
										el.plbdata.curDate = new Date(y, m, 1);
									}
								}
								pb.css("z-index", zorder);
								PlbWebBasic.prototype.AddPlbDtEv(rMsg, dt);
							}
							});
						} else {
							pb.datepicker('option', { onClose: function (dt) { PlbWebBasic.prototype.AddPlbDtEv(rMsg, dt); } });
						}
						break;
					case 7:
						pb.datepicker("hide");
						break;
					case 20:
						try { pb.datepicker("option", JSON.parse(rMsg.opt)); }
						catch (exception) { }
						break;
				}
			}

			return true;
		}

		PlbWebBasic.prototype.methDlg = function (rMsg) {
			var pb = $("#" + rMsg.name);
			var el = document.getElementById(rMsg.name);

			if (pb[0] == null) {
				return true;
			}

			switch (rMsg.dwid) {
				case 1:
					el.plbdata.canclose = true;
					pb.dialog("close");
					break;
				case 2:
					pb.dialog("open");
					el.plbdata.canclose = false;
					break;
				case 3:
					pb.dialog("option", "title", rMsg.str);
					break;
				case 4:
					pb.dialog("option", "width", rMsg.val);
					break;
				case 5:
					pb.dialog("option", "height", rMsg.val);
					break;
				case 6:
					pb.parent().css("top", rMsg.val);
					break;
				case 7:
					pb.parent().css("left", rMsg.val);
					break;
				case 8:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;
					myResult.v = pb.parent().css("top");
					myResult.h = pb.parent().css("left");
					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
					break;
				case 20:
					try { pb.dialog("option", JSON.parse(rMsg.opt)); }
					catch (exception) { }
					break;
			}

			return true;
		}

		PlbWebBasic.prototype.methFrm = function (rMsg) {
			var pb = $("#" + rMsg.name);
			var el = document.getElementById(rMsg.name);

			if (pb[0] == null) {
				return true;
			}

			switch (rMsg.dwid) {
				case 1:
					if ((el.plbdata.resize != undefined) && el.plbdata.resize) {
						pb.resizable("destroy");
					}
					break;
				case 2:
					if ((el.plbdata.resize != undefined) && el.plbdata.resize) {
						pb.resizable({
							autoHide: true,
							minHeight: 50,
							minWidth: 50,
							alsoResize: "#" + rMsg.name + "D"
						});
					}
					break;
			}
			return true;
		}

		PlbWebBasic.prototype.methPict = function (rMsg) {
			var el = document.getElementById(rMsg.name);

			switch (rMsg.dwid) {
				case 1:
					myResult = new Object();
					myResult.action = 2;
					myResult.result = 0;
					if (el != null) {
						myResult.v = el.naturalHeight;
						myResult.h = el.naturalWidth;
						myResult.c = el.complete;
					} else {
						myResult.v = 0;
						myResult.h = 0;
						myResult.c = true;
					}
					PlbWebBasic.prototype.sendMsg(myResult);
					return false;
					break;
				case 2:
					if (el == null) {
						el.width = rMsg.h;
						el.height = rMsg.v;
					}
					break;
			}
			return true;
		}

		PlbWebBasic.prototype.methFile = function (rMsg) {
			var files, file, blob, flrd;
			var el = document.getElementById(rMsg.name);

			if (el == null) {
				return true;
			}
			switch (rMsg.dwid) {
				case 1:
					if (rMsg.typ != undefined) {
						el.accept = rMsg.typ;
					}

					if (rMsg.mult != undefined) {
						if (rMsg.mult == 1) {
							el.multiple = true;
						}
						else {
							el.multiple = false;
						}
					}
					break;
				case 2:
					files = el.files;
					if ((files == undefined) || (files.length <= rMsg.fo)) {
						return true;
					}
					file = files[rMsg.fo];
					blob = file.slice(rMsg.fs, rMsg.fe);
					flrd = new FileReader();

					flrd.onloadend = function (evt) {
						if (evt.target.readyState == FileReader.DONE) {
							PlbWebBasic.prototype.dataMsg(evt.target.result);
						}
					}
					flrd.readAsArrayBuffer(blob);
					return false;
					break;
			}
			return (true);
		}

		PlbWebBasic.prototype.setCss = function (rMsg) {
			var el = $(rMsg.en);

			if (el[0] != null) {
				if( rMsg.pn == "outerWidth") {
					el.outerWidth(rMsg.pv);
				}
				else if( rMsg.pn == "outerHeight") {
					el.outerHeight(rMsg.pv);
				}
				else
				el.css(rMsg.pn, rMsg.pv);
			}
		}

		PlbWebBasic.prototype.setClass = function (rMsg) {
			var el = $(rMsg.en);

			if (el[0] != null) {
				if (rMsg.remc != undefined) {
					el.removeClass(rMsg.remc);
				}
				if (rMsg.addc != undefined) {
					if (!el.hasClass(rMsg.addc)) {
						el.addClass(rMsg.addc);
					}
				}
			}
		}

		PlbWebBasic.prototype.setAttr = function (rMsg) {

			var el = $(rMsg.en);

			if (el[0] != null) {
				el.attr(rMsg.pn, rMsg.pv);
			}
		}

		PlbWebBasic.prototype.setProp = function (rMsg) {

			var el = $(rMsg.en);

			if (el[0] != null) {
				el.prop(rMsg.pn, rMsg.pv);
			}
		}

		PlbWebBasic.prototype.setText = function (rMsg) {
			var el = $(rMsg.en);

			if (el[0] != null) {
				el.text(rMsg.pv);
			}
		}

		PlbWebBasic.prototype.setInnerHtml = function (rMsg) {
			var el = $(rMsg.en);

			if (el[0] != null) {
				el[0].innerHTML = rMsg.pv;
			}

			if (rMsg.name != undefined) {
				PlbWebBasic.prototype.SetListEvents(rMsg);
			}
		}

		PlbWebBasic.prototype.getCss = function (rMsg) {
			var el = $(rMsg.en);

			myResult = new Object();
			myResult.action = 10;
			myResult.numval = 0;

			if (el[0] != null) {
				try {
					myResult.data = el.css(rMsg.pn);

					if (rMsg.cv != undefined) {
						if (myResult.data == true) {
							myResult.data = 1;
						}
						else {
							myResult.data = 0;
						}
					}
				}
				catch (exception) {
					myResult.data = "error";
				}
			}
			else {
				myResult.data = "error";
			}

			return myResult;

		}

		PlbWebBasic.prototype.getAttr = function (rMsg) {
			var el = $(rMsg.en);

			myResult = new Object();
			myResult.action = 10;
			myResult.numval = 0;

			if (el[0] != null) {
				try {
					if (rMsg.cv != undefined) {
						if (el.prop(rMsg.pn) == true) {
							myResult.data = 1;
						}
						else {
							myResult.data = 0;
						}
					}
					else {
						myResult.data = el.attr(rMsg.pn);
					}
				}
				catch (exception) {
					myResult.data = "error";
				}
			}
			else {
				myResult.data = "error";
			}

			return myResult;

		}


		PlbWebBasic.prototype.setFocusNow = function (rMsg) {
			var el;
			if (rMsg.name == undefined) {
				window.focus();
			}
			else if( rMsg.sld != undefined ) {
				$("#" + rMsg.name +" .ui-slider-handle").focus();
			}
			else {
				el = document.getElementById(rMsg.name);
				if (el != null) {
					el.focus();
				}
			}
		}

		PlbWebBasic.prototype.deleteObj = function (rMsg) {
			var el, parDiv, pb;

			if (rMsg.form != undefined) {
				pb = $("#" + rMsg.delid);

				pb.dialog("destroy");
			}

			if (rMsg.enum != undefined) {
				pb = $("#" + rMsg.delid.slice(0, -1));

				pb.spinner("destroy");
			}

			if (rMsg.tab != undefined) {
				pb = $("#" + rMsg.delid);

				pb.tabs("destroy");
			}

			if (rMsg.dt != undefined) {
				pb = $("#" + rMsg.delid);

				pb.datepicker("hide");
				pb.datepicker("destroy");
			}

			if (rMsg.menu != undefined) {
				pb = $("#" + rMsg.delid);

				pb.menu("destroy");
			}

			parDiv = document.getElementById(rMsg.delform);

			if (parDiv != null) {
				el = document.getElementById(rMsg.delid);

				if (el != null) {
					try {
						parDiv.removeChild(el);
					}
					catch (exception) {
						rMsg.err = JSON.stringify(exception);
					}
				}
			}
		}

		PlbWebBasic.prototype.setupJqm = function (rMsg) {
			if (mobRtns != null) {
				$('#mainscrn').enhanceWithin();

				$("#" + rMsg.name + " [data-plbid]").each(function () {
					$(this).on("click", { plbref: rMsg.name, plbid: $(this).attr("data-plbid"), et: 99976 }, PlbWebBasic.prototype.jqEvent);
				});
			}
		}

		PlbWebBasic.prototype.setJqEvent = function (rMsg) {
			var el;

			try {
				if (rMsg.sel !== undefined) {
					el = $(rMsg.sel);
				}
				else {
					el = $("#" + rMsg.name);
				}

				if (el[0] != null) {
					if (rMsg.se == 1) {
						el.on(rMsg.eStr, { plbref: rMsg.name, et: 99975 }, PlbWebBasic.prototype.jqEvent);
					}
					else {
						el.off(rMsg.eStr, PlbWebBasic.prototype.jqEvent);
					}
				}
			}
			catch (exception) { }
			return true;
		}

		PlbWebBasic.prototype.setTitle = function (rMsg) {

			try {
				document.title = rMsg.title
			}
			catch (exception) { }
			return true;
		}

		PlbWebBasic.prototype.setJq = function (rMsg) {
			var el;
			try {
				el = $(rMsg.sel);

				if (el[0] != null) {
					switch (rMsg.dwid) {
						case 1: el.css(rMsg.nam, rMsg.val); break;
						case 2: el.prop(rMsg.nam, rMsg.val); break;
						case 3: el.val(rMsg.val); break;
						case 4: el.html(rMsg.val); break;
						case 5: el.text(rMsg.val); break;
						case 6: el.attr(rMsg.nam, rMsg.val); break;
					}
				}
			}
			catch (exception) { }
			return true;
		}

		PlbWebBasic.prototype.getJq = function (rMsg) {
			var el;

			myResult = new Object();
			myResult.action = 10;
			try {
				el = $(rMsg.sel);

				if (el[0] != null) {
					switch (rMsg.dwid) {
						case 1: myResult.val = el.css(rMsg.nam); break;
						case 2: myResult.val = el.prop(rMsg.nam); break;
						case 3: myResult.val = el.val(); break;
						case 4: myResult.val = el.html(); break;
						case 5: myResult.val = el.text(); break;
						case 6: myResult.val = el.attr(rMsg.nam); break;
					}
				}
			}
			catch (exception) {
				myResult.err = JSON.stringify(exception);
			}

			return myResult;
		}

		PlbWebBasic.prototype.createObj = function (rMsg) {
			var el, parDiv, bgObj, focusObj;


			if (rMsg.delid != undefined) {
				PlbWebBasic.prototype.deleteObj(rMsg);
			}

			parDiv = document.getElementById(rMsg.form);

			bgObj = document.createElement("div");

			document.body.appendChild(bgObj);

			bgObj.innerHTML = rMsg.html;

			if (rMsg.name == undefined) {
				el = bgObj.firstChild;

				while (el != null) {
					bgObj.removeChild(el);
					parDiv.appendChild(el);

					el = bgObj.firstChild;
				}
				if (mainUiStyle == 1) {
					$("#mainscrn").accordion("refresh");
				}
			}
			else {
				el = document.getElementById(rMsg.name);

				if (el != null) {
					try {
						el.parentElement.removeChild(el);

						parDiv.appendChild(el);
					}
					catch (exception) {
						rMsg.err = JSON.stringify(exception);
					}
				}
			}

			document.body.removeChild(bgObj);

			if (rMsg.js != undefined) {
				eval(rMsg.js);
			}

			if (rMsg.jqm != undefined) {
				PlbWebBasic.prototype.setupJqm(rMsg);
			}

			focusObj = $('[tabindex=100]');

			focusObj.each(function (index, element) { PlbWebBasic.prototype.setupFocus(element); });

			focusObj.attr("tabindex", "10");

			if (corRtns != null) {
				corRtns.CorCreateObj(rMsg);
			}
		}

		PlbWebBasic.prototype.jsApi = function (rMsg) {

			myResult = new Object();
			myResult.action = 10;

			try {
				myResult.res = eval(rMsg.js);
			}
			catch (exception) {
				myResult.err = JSON.stringify(exception);
			}
			return myResult;

		}

		PlbWebBasic.prototype.getCookie = function (key) {
			var name = key + "=";
			var ca = document.cookie.split(';');
			for (var i = 0; i < ca.length; i++) {
				var c = ca[i];
				while (c.charAt(0) == ' ') c = c.substring(1);
				if (c.indexOf(name) == 0) return c.substring(name.length, c.length);
			}
			return "";
		}

		PlbWebBasic.prototype.setCookie = function (key, val, exdays) {
			var exStr;
			var d = new Date();
			if (exdays == 0) {
				d.setTime(0);
			}
			else {
				d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
			}
			exStr = "expires=" + d.toUTCString();
			document.cookie = key + "=" + val + "; " + exStr;
		}

		PlbWebBasic.prototype.doStore = function (rMsg) {
			myResult = new Object();
			myResult.action = 10;

			if (rMsg.gkey != undefined) {
				try {
					if (rMsg.ses != undefined) {
						myResult.val = sessionStorage.getItem(rMsg.gkey);
					}
					else if (rMsg.cook != undefined) {
						myResult.val = PlbWebBasic.prototype.getCookie(rMsg.gkey);
					}
					else {
						myResult.val = localStorage.getItem(rMsg.gkey);
					}
				}
				catch (exception) {
					myResult.err = JSON.stringify(exception);
				}

				PlbWebBasic.prototype.sendMsg(myResult);
				return false;
			}
			else if (rMsg.sval != undefined) {
				try {
					if (rMsg.ses != undefined) {
						sessionStorage.setItem(rMsg.skey, rMsg.sval);
					}
					else if (rMsg.cook != undefined) {
						PlbWebBasic.prototype.setCookie(rMsg.skey, rMsg.sval, 30);
					}
					else {
						localStorage.setItem(rMsg.skey, rMsg.sval);
					}
				}
				catch (exception) {
					myResult.err = JSON.stringify(exception);
				}

				PlbWebBasic.prototype.sendMsg(myResult);
				return false;
			}
			else {
				try {
					if (rMsg.ses != undefined) {
						myResult.val = sessionStorage.removeItem(rMsg.skey);
					}
					else if (rMsg.cook != undefined) {
						PlbWebBasic.prototype.setCookie(rMsg.skey, "", 0);
					}
					else {
						myResult.val = localStorage.removeItem(rMsg.skey);
					}
				}
				catch (exception) { }
			}
			return true;
		}

		PlbWebBasic.prototype.progError = function (rMsg) {
			var el = document.getElementById("progErr");

			if (el == null) {
				PlbWebBasic.prototype.PlbProgComplete(errUrl);
				return;
			}

			if (mobRtns != null) {
				mobRtns.progError(rMsg, errUrl);
				return;
			}

			document.getElementById("ped").innerHTML = "<pre>" + rMsg.error + "</pre>";

			$("#progErr").dialog({ resizable: false, height: 240, width: 450, modal: true, title: "Program Error",
				close: function (event, ui) { PlbWebBasic.prototype.PlbProgComplete(errUrl); },
				buttons: {
					"Stop": function () {
						$(this).dialog("close");
					}
				}
			});

		}

		PlbWebBasic.prototype.commError = function (sendData) {
			var el;

			if (corRtns != null) {
				PlbWebBasic.prototype.PlbProgComplete("plbappcomerr.html");
				return;
			}

			if (mobRtns != null) {
				mobRtns.commError(sendData, errUrl);
				return;
			}

			el = document.getElementById("commErr");

			el.commRetry = false;

			if (el == null) {
				PlbWebBasic.prototype.PlbProgComplete(errUrl);
				return;
			}

			$("#commErr").dialog({ resizable: false, height: 150, width: 400, modal: true, title: "Communication Error",
				close: function (event, ui) { if (!event.target.commRetry) PlbWebBasic.prototype.PlbProgComplete(errUrl); },
				buttons: {
					"Retry": function () {
						var el1 = document.getElementById("commErr");
						el.commRetry = true;
						$(this).dialog("close");
						sendData.errRetry += 1;
						PlbWebBasic.prototype.sendMsg(sendData);

					},
					"Abort": function () {
						$(this).dialog("close");
					}
				}
			});

		}

		PlbWebBasic.prototype.commErrorNr = function () {
			var el;

			el = document.getElementById("commErr");

			el.commRetry = false;

			if (el == null) {
				PlbWebBasic.prototype.PlbProgComplete(errUrl);
				return;
			}

			if (mobRtns != null) {
				mobRtns.commErrorNr(errUrl);
				return;
			}

			$("#commErr").dialog({ resizable: false, height: 150, width: 400, modal: true, title: "Communication Error",
				close: function (event, ui) { if (!event.target.commRetry) PlbWebBasic.prototype.PlbProgComplete(errUrl); },
				buttons: {
					"Abort": function () {
						$(this).dialog("close");
					}
				}
			});

		}

		PlbWebBasic.prototype.sendMsg = function (sendData) {
			var self = this;

			self.xmlHttpReq = new XMLHttpRequest();

			self.xmlHttpReq.open('POST', commAddr + 'mq', true);

			self.xmlHttpReq.setRequestHeader('Content-Type', 'application/json');

			self.xmlHttpReq.onreadystatechange = function () {
				if (self.xmlHttpReq.readyState == 4) {
					if ((self.xmlHttpReq.status > 0) && (self.xmlHttpReq.status < 300)) {
						PlbWebBasic.prototype.processMsg(self.xmlHttpReq.responseText);
					}
					else {
						PlbWebBasic.prototype.commError(sendData);
					}
				}
			}

			self.xmlHttpReq.onerror = function () {
				PlbWebBasic.prototype.commError(sendData);
			}

			sendData.progId = progId;
			sendData.errRetry = 0;
			sendData.cntSendMsg = cntSendMsg++;
			self.xmlHttpReq.send(JSON.stringify(sendData));
		}


		PlbWebBasic.prototype.termMsg = function (sendData, fMainQ) {
			var self = this;

			self.xmlHttpReq = new XMLHttpRequest();

			if (fMainQ) {
				self.xmlHttpReq.open('POST', commAddr + 'mq', false);
			}
			else {
				self.xmlHttpReq.open('POST', commAddr + 'tq', false);
			}

			self.xmlHttpReq.setRequestHeader('Content-Type', 'application/json');

			sendData.progId = progId;
			sendData.errRetry = 0;
			sendData.cntSendMsg = cntSendMsg++;

			self.xmlHttpReq.send(JSON.stringify(sendData));
		}

		PlbWebBasic.prototype.dataMsg = function (sendData) {
			var self = this;

			self.xmlHttpReq = new XMLHttpRequest();

			self.xmlHttpReq.open('POST', commAddr + 'dq', true);

			self.xmlHttpReq.setRequestHeader('Content-Type', 'multipart/form-data');
			self.xmlHttpReq.setRequestHeader('Plb-Id', progId.toString());

			self.xmlHttpReq.onreadystatechange = function () {
				if (self.xmlHttpReq.readyState == 4) {
					if (self.xmlHttpReq.status < 300) {
						PlbWebBasic.prototype.processMsg(self.xmlHttpReq.responseText);
					}
					else {
						PlbWebBasic.prototype.commErrorNr();
					}
				}
			}

			self.xmlHttpReq.onerror = function () {
				PlbWebBasic.prototype.commErrorNr();
			}

			self.xmlHttpReq.send(sendData);
		}

		PlbWebBasic.prototype.processMsg = function (respData) {
			var rMsgs;
			var msgCount = 1;
			var fDefSendMsg = true;
			var rMsg;

			try {
				rMsg = JSON.parse(respData);
			}

			catch (exception) {
				PlbWebBasic.prototype.PlbProgComplete("plbweberror.html");
				return;
			}

			if (rMsg.msgs != undefined) {
				if (Array.isArray(rMsg.msgs)) {
					rMsgs = rMsg.msgs;
					msgCount = rMsgs.length;
				}
			}

			while (msgCount--) {
				if (rMsgs != undefined) {
					rMsg = rMsgs.shift();
				}
				switch (rMsg.action) {
					case 3:
						if (rMsg.error == undefined) {
							if ((rMsg.term != undefined) && (curItUrl != null)) {
								rMsg.endUrl = curItUrl;
							}

							PlbWebBasic.prototype.PlbProgComplete(rMsg.endUrl);
						}
						else {
							PlbWebBasic.prototype.progError(rMsg);
						}
						msgCount = 0;
						fDefSendMsg = false;
						break;

					case 4:
						PlbWebBasic.prototype.PlbAlert(rMsg);
						break;

					case 5:
						if (rMsg.uiStyle != undefined) {
							mainUiStyle = rMsg.uiStyle;
						}
						if (mainUiStyle == 1) {
							$("#mainscrn").accordion({ heightStyle: "content" });
						}
						PlbWebBasic.prototype.createObj(rMsg);
						PlbWebBasic.prototype.progSetup(rMsg);
						if (mainUiStyle == 1) {
							$("#mainscrn").accordion("refresh");
						}
						break;

					case 6:
						PlbWebBasic.prototype.eventReg(rMsg);
						break;

					case 7:
						if ((preBrwH != window.innerHeight) || (preBrwV != window.innerWidth)) {
							preBrwH = window.innerHeight;
							preBrwV = window.innerWidth;
							PlbWebBasic.prototype.makeEvent(8, 99985, 0x20, Math.round(window.innerWidth), Math.round(window.innerHeight), "brw", 0);
						}
						if (eventQue.length > 0) {
							PlbWebBasic.prototype.sendMsg(eventQue.shift());
						}
						else if ((corRtns != null) && (rMsg.tm > 200)) {
							eventEventNeedsSend = true;
							eventWaitTimer = window.setTimeout(function () { PlbWebBasic.prototype.WaitEventTimeout(rMsg.tm - 200) }, 200);
						}
						else {
							eventEventNeedsSend = true;
							eventWaitTimer = window.setTimeout(function () { PlbWebBasic.prototype.WaitEventTimeout(0) }, rMsg.tm);
						}
						msgCount = 0;
						fDefSendMsg = false;
						break;

					case 9:
						PlbWebBasic.prototype.sendMsg(PlbWebBasic.prototype.getAttr(rMsg));
						msgCount = 0;
						fDefSendMsg = false;
						break;

					case 11:
						fDefSendMsg = PlbWebBasic.prototype.methSld(rMsg);
						break;

					case 12:
						errUrl = rMsg.errUrl;
						if (progId == 0) {
							progId = rMsg.progId;
						}
						if (corRtns != null) {
							if (rMsg.sver == undefined) {
								window.onbeforeunload = null;
								location.replace("plbappbadver.html");
							}
							corRtns.setUpload(commAddr, progId);
						}

						PlbWebBasic.prototype.sendMsg({ action: 13, version: 1 });
						msgCount = 0;
						fDefSendMsg = false;
						break;

					case 14:
						PlbWebBasic.prototype.setFocusNow(rMsg);
						break;

					case 15:
						msgCount = 0;
						if (eventQue.length > 0) {
							PlbWebBasic.prototype.sendMsg(eventQue.shift());
							fDefSendMsg = false;
						}
						break;

					case 16:
						fDefSendMsg = PlbWebBasic.prototype.methDlist(rMsg);
						break;

					case 17:
						if (rMsg.errUrl == undefined) {
							if (rMsg.itUrl == undefined) {
								curItUrl = null;
							}
							else {
								curItUrl = rMsg.itUrl;
							}
						}
						else {
							errUrl = rMsg.errUrl;
						}
						break;

					case 18:
						PlbWebBasic.prototype.PlbProgError(rMsg);
						break;

					case 19:
						PlbWebBasic.prototype.createObj(rMsg);
						break;

					case 20:
						PlbWebBasic.prototype.deleteObj(rMsg);
						break;

					case 21:
						fDefSendMsg = PlbWebBasic.prototype.methEdit(rMsg);
						break;

					case 22:
						PlbShape(rMsg);
						break;

					case 23:
						PlbWebBasic.prototype.setCss(rMsg);
						break;

					case 24:
						PlbWebBasic.prototype.setAttr(rMsg);
						break;

					case 25:
						fDefSendMsg = PlbWebBasic.prototype.methPBar(rMsg);
						break;

					case 26:
						PlbWebBasic.prototype.setText(rMsg);
						break;

					case 27:
						fDefSendMsg = PlbWebBasic.prototype.methDt(rMsg);
						break;

					case 28:
						PlbWebBasic.prototype.sendMsg(PlbWebBasic.prototype.getCss(rMsg));
						msgCount = 0;
						fDefSendMsg = false;
						break;

					case 29:
						fDefSendMsg = PlbWebBasic.prototype.methDlg(rMsg);
						break;

					case 30:
						PlbWebBasic.prototype.sendMsg(PlbWebBasic.prototype.jsApi(rMsg));
						msgCount = 0;
						fDefSendMsg = false;
						break;

					case 31:
						fDefSendMsg = PlbWebBasic.prototype.methEditNum(rMsg);
						break;

					case 32:
						fDefSendMsg = PlbWebBasic.prototype.methTab(rMsg);
						break;

					case 33:
						PlbWebBasic.prototype.mainDisp(rMsg);
						break;

					case 34:
						PlbWebBasic.prototype.mainKey(rMsg);
						msgCount = 0;
						fDefSendMsg = false;
						break;

					case 35:
						fDefSendMsg = PlbWebBasic.prototype.methPan(rMsg);
						break;

					case 36:
						fDefSendMsg = PlbWebBasic.prototype.methMenu(rMsg);
						break;

					case 37:
						fDefSendMsg = PlbWebBasic.prototype.methCli(rMsg);
						break;

					case 38:
						PlbWebBasic.prototype.setClass(rMsg);
						break;

					case 39:
						PlbWebBasic.prototype.setProp(rMsg);
						break;

					case 40:
						fDefSendMsg = PlbWebBasic.prototype.methLv(rMsg);
						break;

					case 41:
						PlbWebBasic.prototype.eventUnReg(rMsg);
						break;

					case 42:
						PlbWebBasic.prototype.getRect(rMsg);
						msgCount = 0;
						fDefSendMsg = false;
						break;

					case 43:
						PlbWebBasic.prototype.getIoCan(rMsg);
						msgCount = 0;
						fDefSendMsg = false;
						break;

					case 44:
						fDefSendMsg = PlbWebBasic.prototype.methFrm(rMsg);
						break;

					case 45:
						fDefSendMsg = PlbWebBasic.prototype.methFile(rMsg);
						break;

					case 46:
						PlbWebBasic.prototype.setInnerHtml(rMsg);
						break;

					case 47:
						fDefSendMsg = PlbWebBasic.prototype.methPict(rMsg);
						break;

					case 48:
						fDefSendMsg = PlbWebBasic.prototype.doStore(rMsg);
						break;

					case 49:
						fDefSendMsg = PlbWebBasic.prototype.methTv(rMsg);
						break;

					case 50:
						fDefSendMsg = PlbWebBasic.prototype.setJqEvent(rMsg);
						break;

					case 51:
						fDefSendMsg = PlbWebBasic.prototype.setJq(rMsg);
						break;

					case 52:
						PlbWebBasic.prototype.sendMsg(PlbWebBasic.prototype.getJq(rMsg)); ;
						msgCount = 0;
						fDefSendMsg = false;
						break;

					case 53:
						fDefSendMsg = PlbWebBasic.prototype.setTitle(rMsg);
						break;

					case 54:
						fDefSendMsg = PlbWebBasic.prototype.methTb(rMsg);
						break;

					case 55:
						PlbWebBasic.prototype.plbDragItem(rMsg);
						break;

					default:
						if ((corRtns != null) && (rMsg.action >= 500) && (rMsg.action < 600)) {
							fDefSendMsg = false;

							PlbWebBasic.prototype.sendMsg(corRtns.processCorMsg(rMsg));
						}
						else if ((mobRtns != null) && (rMsg.action >= 600) && (rMsg.action < 700)) {
							fDefSendMsg = false;

							PlbWebBasic.prototype.sendMsg(mobRtns.processMobMsg(rMsg));
						}
						msgCount = 0;
						break;
				}
			}

			if (fDefSendMsg) {
				PlbWebBasic.prototype.sendMsg({ action: 2, result: 1 });
			}

		}

		return PlbWebBasic;
	})();

})();
