+==============================================================================
.
. Date:	 04 Apr	1995
.
. Purpose: This	sample program demonstrates the	use of a FLOAT menu object.
.	   This	program	uses a MREGION to cover	part of	the WINDOW.  When
.	   the user clicks with	the left mouse button in the MREGION, then
.	   coordinates of the MREGION is determined and	a FLOAT	menu is	
.	   activated at	those coordinates.  When the right mouse button	is
.	   used, then a	different FLOAT	menu is	presented.
.
*------------------------------------------------------------------------------
.
	include	plbequ.inc
.
Form	Plform	"mb_floatm.pwf"
A	 FLOATMENU
A2	 FLOATMENU
B	 MREGION
R	 FORM	   9
D	 FORM	   4
Z	 FORM	   1
H	 FORM	   4
Msg Dim 40

SubMenu		SubMenu
SubData	Init	";Green;Red;Blue"

*------------------------------------------------------------------------------
.
.	 SETMODE   *PIXEL=ON
	 Formload	Form
.
. Create FLOAT menu which uses the left	mouse button
.
         CREATE    WebForm1;A=2:2:2:25,"a;Menu Item 1<F2;Compiler;-;Menu Item 3"
	 CHECKITEM A,1,ON
.
. Create FLOAT menu can	use the	RIGHT mouse button
.
	 CREATE	   WebForm1;A2=2:2:2:25,"a;Alt Item 1;(Alt Item 2;Alt Item 3":
		   RIGHTBUTTON
.
	CREATE		SubMenu,SubData,A,2
	ACTIVATE	SubMenu,X3,R
.
. Create a MREGION ( mouse region ) to cover part of the window	used.
.
;..WINSHOW	//Debug problem when mainwindow is visible.
.
	 CREATE	   WebForm1;B=0:250:0:300
	 ACTIVATE  B,X,R
.
. This is the main program loop
.
	 LOOP
	  WAITEVENT
	 REPEAT
.
. This action routine processed	events for the MREGION object.	The routine
. determines wheither the left or right	button is used as well as the
. Vertical and Horizontal coordinates where the	mouse was clicked in the
. mouse	region.	 Once this information is determined then the appropriate
. FLOAT	menu is	activated at the coordinates where the mouse was clicked.
.
. Note:	The new	SETPROP	statement was used to change the TOP and LEFT 
.	coordinates of the FLOAT menu objects.
.
X
	 MOVE	   R TO	D	     ;Get the TOP coordinate
	 CALC	   H=R/10000	     ;Calculate	the LEFT coordinate
	 CALC	   Z=R/100000000     ;Calculate	the 9th	digit of the result
.
. Show the TOP and LEFT	coordinates
.
	Pack  Msg Using "V=",D,"  H=",H
	Info.AddString Using Msg
.
. Use the set property (SETPROP) statement to change the TOP/LEFT coordinates
. of the FLOAT menu objects.
.
	 SETPROP   A,TOP=D,LEFT=H
	 SETPROP   A2,TOP=D,LEFT=H
.
. When the value of Z is 0 or 2, then the left mouse button was	used.
. Otherwise, the right mouse button was	used.
.
	 IF	 ( Z = 0 | Z = 2 )
	  Pack  Msg Using "A  X:",R
	  Info.AddString Using Msg
	  ACTIVATE A,X1,R		  ;Show	FLOAT menu for LEFT mouse
	 ELSE
	  Pack  Msg Using "A2 X:",R
	  Info.AddString Using Msg
	  ACTIVATE A2,X2,R		  ;Show	FLOAT menu for RIGTH mouse
	 ENDIF
	 RETURN
.
. This is the action routine for either	FLOAT menu object.  This routine
. simply shows the result value	passed to the action routine.
.
X1
	Pack  Msg Using "ITEM:",R
	Info.AddString Using Msg
	 CHECKITEM A,1,OFF
	 RETURN

X2
	Pack  Msg Using "ITEM:",R
	Info.AddString Using Msg
	 CHECKITEM A,1,ON
	 RETURN

X3
	Pack  Msg Using "SUBMENU ITEM:",R
	Info.AddString Using Msg
	 RETURN
