+------------------------------------------------------------------------------
. Sample Master program for PL/B Web Server
.
NVAR	FORM	3
ProgNam	DIM	100
D80	DIM	80
MAIN	MAINWINDOW
VER	DIM	5
.
.
CLIENT  CLIENT
Browser DIM  50
.
Screen		RECORD
availHeight	DIM	10
availWidth	DIM	10
colorDepth	DIM	10
height		DIM	10
pixelDepth	DIM	10
width		DIM	10
        	RECORDEND
.
Navigator	RECORD
appCodeName	DIM	100
appName		DIM	100
appVersion	DIM	100
cookieEnabled	DIM	3
language	DIM	20
platform	DIM	100
product		DIM	100
userAgent	DIM	500
		RECORDEND
.
X	PLFORM	PWSMASTER.PWF
.
Start
	EXCEPTSET ChainError NORESET IF CFAIL
.
	GETPROP MAIN,VISIBLE=NVAR
	IF ( NVAR != 0 )
	  WINHIDE
	ENDIF
.
	CHOP S$ERROR$
	TYPE S$ERROR$
	IF NOT EOS
	  ALERT NOTE,S$ERROR$,NVAR,"PLB Answer error recovery"
	  UNPACK "",S$ERROR$
	ENDIF
.
	TEST WebForm1			;Is the .PWF form already loaded!
	IF ZERO
	  FORMLOAD X
	ENDIF
.
. Show Runtime and Client Browser Version
.
	DEBUG
	CLOCK VERSION,VER
	PACK D80,"Version: ",VER
.
	CALL GetBrowser USING Browser
	TYPE Browser
	IF NOT EOS
	  PACK D80,D80,"   Client: ",Browser
	ENDIF
	SETPROP	VersionST,TEXT=D80
.
	TYPE S$CMDLIN
	IF NOT EOS
	  SETPROP CmdLineET,TEXT=S$CMDLIN
	ENDIF
.
	LOOP
	  WAITEVENT
	REPEAT
.-----------------------------------------------------------------------------
.
nRadio	FORM	3
.
CHAIN
	GETPROP Radio1,VALUE=nRadio			;AddrWeb.plc
	IF ( nRadio )
	  DELETEITEM EditText1,0
	  MOVE "addrweb.plc",ProgNam
	ELSE
	  GETPROP Radio2,VALUE=nRadio		;ProgExit.plc
	  IF ( nRadio )
	    DELETEITEM EditText1,0
	    MOVE "progexit.plc",ProgNam
	  ELSE
	    GETPROP Radio3,VALUE=nRadio		;WebDemo.plc
	    IF ( nRadio )
	      DELETEITEM EditText1,0
	      MOVE "webdemo",ProgNam
	    ELSE
	      GETPROP EditText1,TEXT=ProgNam
	      CHOP ProgNam
	      TYPE ProgNam					;Check for user program
	      IF EOS	   
	        ALERT NOTE,"Program Selection Not Specified!",NVAR,"PLB Answer"
	        RETURN
	      ENDIF
	    ENDIF
	  ENDIF
	ENDIF
.
	GETPROP CmdLineET,TEXT=S$CMDLIN
.
	CHAIN ProgNam
.
. Radio Button for Other Program
.
RadioOther
	SETFOCUS EditText1
	RETURN
.
. Unable to CHAIN
.
ChainError
	PACK D80,"'",ProgNam,"' not found!"
	ALERT NOTE,D80,NVAR,"PLB Answer Chain Error"
	UNPACK "",S$ERROR$
	GOTO Start	//Start over!
.------------------------------------------------------------------------------
. Function to get Client Browser Version
.
GetBrowser  FUNCTION
pBrowser    DIM   ^
	ENTRY
.
DInfo	DIM	1024
DLow	DIM	1024
x7F	INIT	0x7F
FP	FORM	5
LP	FORM	5
NDX	FORM	2
I	FORM	2
cBrwCnt CONST	"7"
BrwNames DIM	50(cBrwCnt):
		("firefox"),("opr"),("trident"),("chrome"),("iphone"):
		("ipad"),("safari")
OutNames DIM	50(cBrwCnt):
		("Firefox"),("Opera"),("IE"),("Chrome"),("IPhone"):
		("IPad"),("Safari")
XVer	DIM	10
.
	DEBUG
	CLEAR	pBrowser
.
	Client.GetInfo GIVING DInfo
	TYPE DInfo
	IF NOT EOS
.
	  EXPLODE DInfo,x7F,Screen,Navigator
	  TYPE Navigator.userAgent
	  IF NOT EOS
	    LOWERCASE  Navigator.userAgent,DLow
	    FOR I,1,cBrwCnt
	      SCAN BrwNames(I),DLow
	      IF EQUAL
	        MOVE I,NDX
	        MOVEFPTR DLow,FP	//Save start of browser found!
	        MOVELPTR BrwNames(I),LP
	        MOVE OutNames(I),pBrowser
	        BREAK
	      ENDIF
	    REPEAT
.
	    TYPE pBrowser
	    IF EOS
	      MOVE "Unknown",pBrowser
	    ELSE
.
. Search the 'userAgent' data for possible version strings.
.
. First default to 'version/n.n.n' string because browser may use the format.
.
	      RESET DLow
	      SCAN "version/",DLow
	      IF EQUAL
	        BUMP DLow,8
	        IF NOT EOS
	          PARSE	DLow,xVer,"09.."
	        ENDIF
	      ENDIF
.
. At this point, the FP MUST be at the first character of the browser name that was found.
.
	      TYPE xVer
	      IF EOS
.
. Scan Internet Explorer for 'rv:nn.nn'
.
	        IF ( NDX == 3 )      //Browser = Internet Explorer
.
	          RESET DLow
	          SCAN "rv:",DLow
	          IF EQUAL
	            BUMP DLow,3
	            IF NOT EOS
	              PARSE DLow,xVer,"09.."
	            ENDIF
	          ENDIF
.
	        ELSE                //Other browser 
.
. Other Browsers except for IE
.
	          RESET DLow,FP		//Reset to beginning of browser name!
	          BUMP DLow,LP		//LP is the length of the browser name found by SCAN!
	          IF NOT EOS
	            CMATCH "/",DLow
	            IF EQUAL
	              BUMP DLow
	              IF NOT EOS
	                PARSE DLow,xVer,"09.."
	              ENDIF 
	            ENDIF
	          ENDIF
	        ENDIF
	      ENDIF
.
. Return Client Browser if it can be extracted from the 'userAgent' data.
.
	      TYPE xVer
	      IF NOT EOS
	        PACK pBrowser,pBrowser," ",xVer
	      ENDIF
.
	    ENDIF	//Browser type not found
.
	  ENDIF		//No Navigator data available
.
	ENDIF		//No GetInfo data available
	FUNCTIONEND
.
