..................................................................
. Sample Program To Download a File to a Client Browser
.
. Demonstrates use of 'Client.Open' method
.
X	 PLFORM	   downloadf.plf
.....
.
RunTime	RUNTIME
Client	CLIENT
.
x0A		INIT	0x0A
.
OutFile		DIM	300	//Output - User DIM to receive selected file!
Scan		DIM	200	//Input  - Path on PWS server where input selection files are located.
Color		COLOR		//Input  - Background color of Selection Window from caller.
Prefix		DIM	50	//Input  - Prefix (example: prt_) or NULL
SearchName	DIM	50	//Input  - Search named (example: '*.*', '*.pdf', ...etc
.
NVAR	  FORM	3
BaseDir	  DIM	150
SaveToDir DIM	150	// PLBWEB_SAVETOCLIENT keyword directory.
.
fType	  FORM	1	//0 - PLBWIN, !0 - PWS
fIsSSL	  FORM	1	//0 - Not SSL, !0 - SSL Used!
fSaveTo   FORM	1	//0 - PLBWEB_SAVETOCLIENT not used, !0 - keyword used
fIsUnix	 FORM	 3		//99 --> Unix PLB runtime!
dPathChr INIT	 "\"		// '\' --> Windows default	 
.
..................................................................
.
StartProg
.
	WINHIDE
.
	FORMLOAD  X
.
	SETPROP   DownLoad, ENABLED=0
	SETPROP   StatText1, TEXT="Select a file to download to client browser!"
.
	CALL	DownLoadSetup
.
	SETFOCUS Select1
.
	LOOP
	  WAITEVENT
	REPEAT
.....
.
Exit
	CLEAR	S$CMDLIN
	STOP
.....
.
SelectFile
.
	DEBUG
	RunTime.GetDir GIVING Scan USING 4   //Retrieve PLBWEB_SSL_ROOT or PLBWEB_ROOT!
	TYPE	Scan
	IF EOS
...
. Not using PWS
. 
	 MOVE	"c:\sunbelt\plbwebsrv.97B\http_root\images", SaveToDir	//Plbwin default! (User MUST add files!)
	 PATH	EXIST, SaveToDir
	 IF OVER
	  PACK  S$CMDLIN, "Path Does Not Exist!", x0A, x0A, SaveToDir
	  ALERT	STOP, S$CMDLIN, NVAR, "DownLoad Demo Path Error!"
	  CLEAR	S$CMDLIN
	  STOP
	 ENDIF
	 MOVE	SaveToDir, Scan
.
	ELSE
...
. Using PWS
. 
	 MOVE	"1", fType		//Using PWS runtime!
	 MOVE	SaveToDir, Scan
...	 PACK	Scan, Scan, dPathChr, "images"	//Account for Unix or Windows!
	ENDIF
.
	MOVE	"*.*", SearchName	
.
	CALLS	"sun_fileselect;StartProg" USING OutFile:	//Output - User DIM to receive selected file!
						 Scan:		//Input  - Path where input selection files located.
						 Color:		//Input  - Background color of Selection Window from caller.
						 Prefix:	//Input  - Prefix (example: prt_) or NULL
						 SearchName	//Input  - Search named (example: '*.*', '*.pdf', ...etc						 
.
. At this point, if the 'OutFile' variable is NULL, then the
. end-user DID NOT select a file. Otherwise, the 'OutFile' variable
. contains the file name that was selected.
.
	TYPE OutFile
	IF EOS
	 SETPROP DownLoad, ENABLED=0
	 SETPROP   StatText1, TEXT="Select a file to download to client browser!"
	 SETFOCUS  Select1
	ELSE
	 SETPROP DownLoad, ENABLED=1
	 PACK S$CMDLIN, "Selected File: '", OutFile, "'"
	 SETPROP   StatText1, TEXT=S$CMDLIN
	 SETFOCUS  DownLoad	
	ENDIF
. 
	RETURN
.....
.
Host	DIM	100
.
DownLoad
	DEBUG
.
	IF ( fType == 0 )
...
. At this point, the runtime is NOT a PWS type.
. The runtime is a PLBNET or PLBWIN type.
. 
	 TYPE	OutFile
	 IF EOS
	  ALERT	   NOTE, "No file is selected by end-user!", NVAR, "DownLoad To Client Browser"
	 ELSE
	  PACK	S$CMDLIN, "End-User selected the file: '", OutFile, "'" 
	  ALERT	   NOTE, S$CMDLIN, NVAR, "DownLoad To Client"
	 ENDIF
.	
	ELSE
...
. The runtime is a PWS type.
.
	 TYPE	OutFile
	 IF EOS
	  ALERT	   NOTE, "No file is selected to download to client!", NVAR, "DownLoad To Client Browser"
	 ELSE
...
. At this point, the operation of the following 'Client.Open'
. depends on the existance of the PWS keyword named 'PLBWEB_SAVETOCLIENT={subdirectory}'.
. 
.   Note:
.      1. If the 'PLBWEB_SAVETOCLIENT' keyword is NOT being used, then the
.         following 'Client.Open' looks for the OutFile file name as follows:
.         
.            Windows:
.               "c:\sunbelt\plbwebsrv.97b\http_root\savetoclient\filename.ext"
.               
.            Unix:
.               "/usr/plbwebsrv.97b/http_root/savetoclient/filename.ext"
.               
.      2. If the 'PLBWEB_SAVETOCLIENT={subdir}' keyword is being used, then the
.         following 'Client.Open' looks for the OutFile file name as follows:
.
.            Plbwebsrv.ini Keyword Used:
.               [environment]
.               PLBWEB_SAVETOCLIENT=images
.
.            Windows:
.               "c:\sunbelt\plbwebsrv.97b\http_root\images\filename.ext"
.               
.            Unix:
.               "/usr/plbwebsrv.97b/http_root/images/filename.ext"
. 
	  Client.Open USING *URL=OutFile, *OPTIONS=1
.
	 ENDIF
.
	ENDIF
	RETURN
.....
. This function initializes to allow the DownLoad Demo to be Executed!
.
DownLoadSetup	FUNCTION
             	ENTRY
...
.
dIn	DIM	300
dOut	DIM	300
dXXX	DIM	300
.
...
	DEBUG
...
. Shortcut to determine if Unix runtime being used.
. 
	GETMODE *DISPFLUSH=fIsUnix	//99-->Unix or !99-->Windows
	IF ( fIsUnix == "99" )
	 MOVE "/", dPathChr	//Unix path character
	ENDIF
.
	Client.GetState GIVING fIsSSL USING *STATEMASK=1
.
	IF ( fIsSSL == 0 )
.
. Not using SSL!
.
	 RunTime.GetDir GIVING BaseDir USING *TYPE=3   //Fetch PLBWEB_ROOT
.
	ELSE
.
. Using SSL!
.
	 RunTime.GetDir GIVING BaseDir USING *TYPE=4   //Fetch PLBWEB_SSL_ROOT 

	ENDIF
...
. Check for PLBWEB_SAVETOCLIENT keyword usage
.
	RunTime.GetDir GIVING dXXX USING *TYPE=5 //Fetch PLBWEB_SAVETOCLIENT directory
	TYPE dXXX
	IF EOS
...
. If the PLBWEB_SAVETOCLIENT keyword is NOT being used, then we MUST
. setup the 'savetoclient' default directory that allows the DownLoad
. demo to execute with encountering an error.
. 
.    1. Create the default 'savetoclient' subdirectory as:
.         %BaseDir%/savetoclient
.
.    2. Copy %BaseDir%/images/sunbelt.png to
.            %BaseDir%/savetoclient/sunbelt.png
.
	 PACK	SaveToDir, BaseDir, dPathChr, "savetoclient"	
	 PATH	EXIST, SaveToDir
	 IF OVER
	  PATH	CREATE, SaveToDir
	  IF OVER
	   ALERT STOP, SaveToDir, NVAR, "DownLoad Path Create Error!"
	   CLEAR S$CMDLIN
	   STOP
	  ELSE
	   PACK	dIn, BaseDir, dPathChr, "images", dPathChr, "sunbelt.png"
	   PACK	dOut, SaveToDir, dPathChr, "sunbelt.png"
	   COPYFILE dIn, dOut
	   IF OVER
	    ALERT STOP, dIn, NVAR, "DownLoad CopyFile Error!"
	    CLEAR S$CMDLIN
	    STOP
	   ENDIF
	  ENDIF
	 ENDIF
.
	ELSE
	 SET fSaveTo
	 PACK SaveToDir, BaseDir, dPathChr, dXXX	//Use PLBWEB_SAVETOCLIENT keyword sub-directory!
	ENDIF	
.
	FUNCTIONEND
.	
.....
