/*-----------------------------------------------------------------------------
  EXTCALL tutorial program.

  Functions that are callable from the 'c' routines:

  char *Var;
  char *Addr;
  int Type;
  int PL;
  int FP;
  int LL;
  int Status;

  (void) ClearEos ();				; Clear EOS flag

  (void) ClearLess ();				; Clear LESS flag

  (void) ClearOver ();				; Clear OVER flag

  (void) ClearZero ();				; Clear ZERO flag

  Type = GetArg ( &Var, &Addr, &PL, &FP, &LL);	; Get Next Argument & Type
	Var = Address of first byte of data item
	Addr = Address of first byte of user data
	PL = Physical length of field
	FP = Dim: Form Pointer
	     Form: Whole Digits in field
	LL = Dim: Logical Length Pointer
	     Form: Fractional Digits in field
	Type = 0: End of Argument List
	       1: Dim variable
	       2: Form variable
	       3: Integer variable
	      99: Other

  Status = SetArg ( Var, FP, LL);		; Set FP & LL
	NOTE: Only valid for DIM field
	Status = 0 if Modifications were made
		 1 if not modifications were made

  (void) SetEos ();				; Set EOS flag

  (void) SetLess ();				; Set LESS flag

  (void) SetOver ();				; Set OVER flag

  (void) SetZero ();				; Set ZERO flag

  Status = TestEos ();				; Test EOS flag

  Status = TestLess ();				; Test LESS flag

  Status = TestOver ();				; Test OVER flag

  Status = TestZero ();				; Test ZERO flag
*/

/*-----------------------------------------------------------------------------
  Sample Include Module for several C routines to be included in a PL/B
  program.
*/

extcall ( function )
char	*function;
{
int	retval = 0;

	ClearOver ();
	switch ( *function )
	    {
		case '1':
			retval = Function1 ();
			break;
		case '2':
			retval = Function2 ();
			break;
		case '3':
			retval = Function3 ();
			break;
		case '4':
			retval = Function4 ();
			break;
		default:
			SetOver ();
	    }
	return ( retval );
}

/*------------------------------------------------------------------------------
  dspNAME0 will take a list of variables passed to the routine and 
  give some information about those variables.
*/

Function1 ()
{
char	*Var;
char	*VarAddr;
int	VarType;
int	VarFP;
int	VarLL;
int	VarPL;

	while ( ( VarType = GetArg ( &Var, &VarAddr, &VarPL, &VarFP, &VarLL ) ) > 0 )
	    {
		switch ( VarType )
		    {
			case 1:
				printf ( "Dim:     Addr:%.8X  Data:%.8X  FP=%d  LL=%d  PL=%d\n\r", Var, VarAddr, VarFP, VarLL, VarPL );
				break;
			case 2:
				printf ( "Form:    Addr:%.8X  Data:%.8X  TD=%d  WD=%d  FD=%d\n\r", Var, VarAddr, VarPL, VarFP, VarLL );
				break;
			case 3:
				printf ( "Integer: Addr:%.8X  Data:%.8X  WD=%d\n\r", Var, VarAddr, VarPL );
				break;
			default:
				printf ( "Other:   Type=%d\n\r", VarType );
		    }
	    }
	return ( VarType );
}

/*-----------------------------------------------------------------------------
*/

Function2 ()
{
	printf ( "\n\rNAME1:....:\n\r" );
	return ( 0 );			
}

/*-----------------------------------------------------------------------------
*/

Function3 ()
{
	printf ( "\n\rNAME2:....:\n\r" );
	return ( 1 );	/* Return an error code */
}

/*-----------------------------------------------------------------------------
*/

Function4 ()
{
char	*Var;
char	*VarAddr;
int	VarType;
int	VarFP;
int	VarLL;
int	VarPL;
int	retval = 0;

	VarType = GetArg ( &Var, &VarAddr, &VarPL, &VarFP, &VarLL );
	retval = SetArg ( Var, VarPL, VarPL );
	return ( retval );
}
